package tanker

import (
	"time"
)

type StringID string
type Locale string

const (
	HotelBooking        StringID = "_Booking_"
	Print               StringID = "_Print_"
	WebCheckIn          StringID = "_Checkin_"
	Aeroexpress         StringID = "_Aeroexpress_"
	Taxi                StringID = "_Taxi_"
	FreeCancelDate      StringID = "_FreeCancelDate_"
	FreeCancelDateShort StringID = "_FreeCancelDateShort_"
	ChangeBooking       StringID = "_ChangeBooking_"
	CheckWeather        StringID = "_CheckWeather_"
	Row                 StringID = "_Row_"
	Seat                StringID = "_Seat_"
	And                 StringID = "_And_"
	Delete              StringID = "_Delete_"
	Faq                 StringID = "_Faq_"
	Compose             StringID = "_Compose_"
	ConfirmEmail        StringID = "_ConfirmEmail_"
	RestorePassword     StringID = "_RestorePassword_"
	Unsubscribe         StringID = "_Unsubscribe_"
	YourOrder           StringID = "_YourOrder_"
	GoToOrder           StringID = "_GoToOrder_"
	BoardingPass        StringID = "_BoardingPass_"
	WillGo              StringID = "_WillGo_"
	WillNotGo           StringID = "_WillNotGo_"
	Look                StringID = "_Look_"
	Updated             StringID = "_Updated_"
	FreeTime            StringID = "_FreeTime_"
	Spam                StringID = "_Spam_"
)

const (
	DefaultLocale Locale = ""
)

type Interface interface {
	GetString(id StringID) (string, error)
	GetTimeInterval(start, end time.Time) string
	GetDay(t time.Time) (string, error)
	GetDate(t time.Time) (string, error)
	GetDateShort(t time.Time) (string, error)
	GetTickets(num int) (string, error)
	GetNights(num int) (string, error)
	GetSuccessBounce(recipients []string) (string, error)
	GetIPBlockedBounce(recipients []string) (string, error)
	GetType1Bounce(recipients []string) (string, error)
	GetType2Bounce(recipients []string) (string, error)
	GetType3Bounce(recipients []string) (string, error)
	GetType4Bounce(recipients []string) (string, error)
	GetType5Bounce(recipients []string) (string, error)
	GetType6Bounce(recipients []string) (string, error)
	GetType8Bounce(recipients []string) (string, error)
	GetDmarcBounce(originalFrom string) (string, error)
	GetMXS(domain string) (string, error)
	GetEshopStatus(status string) (string, error)
	GetCancelledEvent(event string) (string, error)
}
