package tanker

import (
	"fmt"
	"time"
)

type Mock struct{}

func (Mock) GetString(id StringID) (string, error) {
	return string(id), nil
}

func (Mock) GetTimeInterval(start, end time.Time) string {
	return fmt.Sprintf("from %v till %v", start.Format("15:04"), end.Format("15:04"))
}

func (Mock) GetDay(t time.Time) (string, error) {
	return t.Format("Mon"), nil
}

func (Mock) GetDate(t time.Time) (string, error) {
	return t.Format("Jan 2"), nil
}

func (Mock) GetDateShort(t time.Time) (string, error) {
	return t.Format("Jan. 2"), nil
}

func (Mock) GetTickets(num int) (res string, err error) {
	res = fmt.Sprintf("%v билета", num)
	return
}

func (Mock) GetNights(num int) (res string, err error) {
	res = fmt.Sprintf("%v _Nights_", num)
	return
}

func (Mock) GetSuccessBounce(recipients []string) (res string, err error) {
	res = fmt.Sprintf("success bounce to %v", recipients)
	return
}

func (Mock) GetIPBlockedBounce(recipients []string) (res string, err error) {
	res = fmt.Sprintf("ip_blocked bounce to %v", recipients)
	return
}

func (Mock) GetType1Bounce(recipient []string) (res string, err error) {
	res = fmt.Sprintf("type1 bounce to %v", recipient)
	return
}

func (Mock) GetType2Bounce(recipient []string) (res string, err error) {
	res = fmt.Sprintf("type2 bounce to %v", recipient)
	return
}

func (Mock) GetType3Bounce(recipient []string) (res string, err error) {
	res = fmt.Sprintf("type3 bounce to %v", recipient)
	return
}

func (Mock) GetType4Bounce(recipient []string) (res string, err error) {
	res = fmt.Sprintf("type4 bounce to %v", recipient)
	return
}

func (Mock) GetType5Bounce(recipient []string) (res string, err error) {
	res = fmt.Sprintf("type5 bounce to %v", recipient)
	return
}

func (Mock) GetType6Bounce(recipient []string) (res string, err error) {
	res = fmt.Sprintf("type6 bounce to %v", recipient)
	return
}

func (Mock) GetType8Bounce(recipient []string) (res string, err error) {
	res = fmt.Sprintf("type8 bounce to %v", recipient)
	return
}

func (Mock) GetDmarcBounce(originalFrom string) (res string, err error) {
	res = fmt.Sprintf("dmarc from %v", originalFrom)
	return
}

func (Mock) GetMXS(domain string) (res string, err error) {
	res = fmt.Sprintf("mx %v", domain)
	return
}

func (Mock) GetEshopStatus(status string) (string, error) {
	if status == "unknown" {
		return "", Error("unknown status")
	}
	return status, nil
}

func (Mock) GetCancelledEvent(event string) (string, error) {
	return fmt.Sprintf("Event \"%v\" cancelled", event), nil
}
