package tutil

import (
	"reflect"
	"sort"
	"strconv"
	"strings"
)

func ContainsInt(s sort.IntSlice, v int) bool {
	var i = s.Search(v)
	if i < s.Len() {
		return s[i] == v
	}
	return false
}

func onIntersection(s1 []int, s2 sort.IntSlice, exit func(int) bool) bool {
	for _, i1 := range s1 {
		if ContainsInt(s2, i1) && exit(i1) {
			return true
		}
	}
	return false
}

func Intersects(s1 []int, s2 sort.IntSlice) bool {
	return onIntersection(s1, s2, func(int) bool { return true })
}

func Intersection(s1 []int, s2 sort.IntSlice) []int {
	res := []int{}
	onIntersection(s1, s2, func(v int) bool {
		res = append(res, v)
		return false
	})
	return res
}

func Includes(set sort.IntSlice, subset []int) bool {
	intersection := Intersection(subset, set)
	return reflect.DeepEqual(intersection, subset)
}

func Ints2Strings(ints []int) []string {
	strings := []string{}
	for _, i := range ints {
		s := strconv.Itoa(i)
		strings = append(strings, s)
	}
	return strings
}

func PrintIntSlice(v []int) string {
	return strings.Join(Ints2Strings(v), ", ")
}

func Strings2Ints(strings []string) (res []int) {
	res, _ = Strings2IntsStrict(strings)
	return
}

func Strings2IntsStrict(strings []string) (ints []int, lastErr error) {
	ints = []int{}
	for _, s := range strings {
		i, err := strconv.Atoi(s)
		if err == nil {
			ints = append(ints, i)
		} else {
			lastErr = err
		}
	}
	return
}

func ContainsString(str string, slice []string) bool {
	for _, elem := range slice {
		if elem == str {
			return true
		}
	}
	return false
}
