package tutil

import (
	"strings"
	"time"
)

type Timeout time.Duration

func (timeout *Timeout) UnmarshalJSON(buf []byte) (err error) {
	d, e := time.ParseDuration(strings.Trim(string(buf), "\""))
	*timeout = Timeout(d)
	return e
}
