package tutil

import (
	"fmt"
	"strconv"
	"time"
)

type Error string

func (e Error) Error() string {
	return "tutil error: " + string(e)
}

func GetTimeFromSomething(something interface{}) (res time.Time, err error) {
	var i int
	switch typ := something.(type) {
	case string:
		i, err = strconv.Atoi(something.(string))
		if i != 0 {
			res = time.Unix(int64(i), 0)
		} else {
			res, err = time.Parse("02.01.2006 15:04:05", something.(string))
			if err != nil {
				res, err = time.Parse("2006-01-0215:04", something.(string))
			}
		}
	case int:
		res = time.Unix(int64(something.(int)), 0)
	case int64:
		res = time.Unix(something.(int64), 0)
	case float64:
		res = time.Unix(int64(something.(float64)), 0)
	default:
		err = Error(fmt.Sprintf("cannot extract time from something of type %T, value=%v", typ, something))
	}
	return
}

func GetTimeFromRfcString(something interface{}) (res time.Time, err error) {
	str, ok := something.(string)
	if !ok {
		err = Error("rfc time string should be at least a string, you know")
		return
	}
	res, err = time.Parse(time.RFC3339, str)
	return
}

func GetIntFromSomething(something interface{}) (res int, err error) {
	switch typ := something.(type) {
	case string:
		res, err = strconv.Atoi(something.(string))
	case int:
		res = something.(int)
	case int64:
		res = int(something.(int64))
	case float64:
		res = int(something.(float64))
	default:
		err = Error(fmt.Sprintf("cannot extract int from something of type %T, value=%v", typ, something))
	}
	return
}
