package weather

import (
	"a.yandex-team.ru/mail/iex/taksa/tutil"
	"fmt"
	"time"
)

type Config struct {
	Host       string        `json:"host"`
	Timeout    tutil.Timeout `json:"timeout"`
	Key        string        `json:"key"`
	HeaderHost string        `json:"header_host"`
}

func (config Config) String() string {
	return fmt.Sprintf("weather url=%v, timeout=%v", config.Host, time.Duration(config.Timeout))
}

func Default() Config {
	return Config{Timeout: tutil.Timeout(time.Duration(100) * time.Millisecond), HeaderHost: ""}
}

func (config Config) GetUnfilledMandatoryFields() (fields []string) {
	if len(config.Host) == 0 {
		fields = append(fields, "weather.host")
	}
	if len(config.Key) == 0 {
		fields = append(fields, "weather.key")
	}
	return
}
