package avia

import (
	"a.yandex-team.ru/mail/iex/taksa/currency"
	"a.yandex-team.ru/mail/iex/taksa/experiments"
	"a.yandex-team.ru/mail/iex/taksa/types"
	"a.yandex-team.ru/mail/iex/taksa/weather"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
)

type Config struct {
	Types           types.Types             `json:"types"`
	Experiments     experiments.Experiments `json:"experiments"`
	Logo            common.LogoCfg          `json:"logo"`
	SearchLink      string                  `json:"search_link"`
	TravelLink      string                  `json:"travel_link"`
	AeroexpressLink string                  `json:"aeroexpress_link"`
	YTaxiLink       string                  `json:"ytaxi_link"`
	Weather         weather.Config          `json:"weather"`
	Currency        currency.Config         `json:"currency"`
}

func Default() Config {
	return Config{Weather: weather.Default(), Currency: currency.Default(), Logo: common.DefaultLogoCfg()}
}

func (config Config) GetUnfilledMandatoryFields() (fields []string) {
	if len(config.Types) == 0 {
		fields = append(fields, "avia.types")
	}
	if len(config.SearchLink) == 0 {
		fields = append(fields, "avia.search_link")
	}
	if len(config.TravelLink) == 0 {
		fields = append(fields, "avia.travel_link")
	}
	if len(config.AeroexpressLink) == 0 {
		fields = append(fields, "avia.aeroexpress_link")
	}
	if len(config.YTaxiLink) == 0 {
		fields = append(fields, "avia.ytaxi_link")
	}
	fields = append(fields, config.Logo.GetUnfilledMandatoryFields()...)
	fields = append(fields, config.Weather.GetUnfilledMandatoryFields()...)
	fields = append(fields, config.Currency.GetUnfilledMandatoryFields()...)
	return
}

func (config Config) GetTypes() types.Types {
	return config.Types
}

func (config Config) GetExperiments() experiments.Experiments {
	return config.Experiments
}
