package avia

import "a.yandex-team.ru/mail/iex/taksa/widgets/common"

type AviaWidget struct{}

func (AviaWidget) Type() string { return "avia" }

type ValidAviaWidget struct {
	common.WidgetBase
	common.ValidTrue
	common.DoubleRowSize
	AviaWidget
}

type ExpiredAviaWidget struct {
	common.WidgetBase
	common.ValidFalse
	common.SingleRowSize
	AviaWidget
}

type FactlessAviaWidget struct {
	common.WidgetBase
	common.ValidTrue
	AviaWidget
	common.SingleRowSize
	common.FactlessSubType
}

type TicketWidget struct {
	ValidAviaWidget
	common.TicketSubType
}

type FlightTomorrowWidget struct {
	ValidAviaWidget
	common.TomorrowSubType
}

type ExpiredTicketWidget struct {
	ExpiredAviaWidget
	common.TicketSubType
}

type ReminderWidget struct {
	ValidAviaWidget
	common.ReminderSubType
}

type BoardingPassWidget struct {
	ValidAviaWidget
	common.BoardingPassSubType
}

type ExpiredBoardingPassWidget struct {
	ExpiredAviaWidget
	common.BoardingPassSubType
}

func (class Class) makeTicketWidget(ticket Ticket) (common.Widget, error) {
	accum := common.Accumulator{}
	accum.Add(
		func() (common.Control, error) {
			return class.getLogo(ticket, common.LogoColorCfg, common.LogoIconRegular)
		},
		func() (common.Control, error) { return class.getTitle() })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getShortRoute(ticket) },
		func() (common.Control, error) { return class.getShortRouteAux(ticket) },
		// https://st.yandex-team.ru/IEX-2068, temporarily
		//func() (Control, error) { return class.getBooking(ticket) },
		func() (common.Control, error) { return class.getPrintOrLink(ticket) })...)
	return common.InitWidget(&TicketWidget{}, class.mid(), &accum, ticket.ExpireDate())
}

func (class Class) makeReminderWidget(ticket Ticket) (common.Widget, error) {
	accum := common.Accumulator{}
	accum.Add(
		func() (common.Control, error) {
			return class.getLogo(ticket, common.LogoColorDefault, common.LogoIconRegular)
		},
		func() (common.Control, error) { return class.getTitle() })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getRoute(ticket) },
		func() (common.Control, error) { return class.getRouteAux(ticket) },
		func() (common.Control, error) { return class.getCheckin(ticket) },
		func() (common.Control, error) { return class.getTransfer(ticket) })...)
	accum.Add(common.Async(common.SuppressError(
		func() (common.Control, error) { return class.getWeather(ticket) },
		func() (common.Control, error) { return class.getCurrency(ticket) })...)...)

	return common.InitWidget(&ReminderWidget{}, class.mid(), &accum, ticket.ExpireDate())
}

func (class Class) makeBoardingPassWidget(ticket Ticket) (common.Widget, error) {
	accum := common.Accumulator{}
	accum.Add(
		func() (common.Control, error) {
			return class.getLogo(ticket, common.LogoColorCfg, common.LogoIconRegular)
		},
		func() (common.Control, error) { return class.getTitle() })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getRoute(ticket) },
		func() (common.Control, error) { return class.getRouteAux(ticket) },
		func() (common.Control, error) { return class.getTransfer(ticket) },
		func() (common.Control, error) { return class.getPrintOrMoreTransfer(ticket) })...)
	accum.Add(common.Async(common.SuppressError(
		func() (common.Control, error) { return class.getWeather(ticket) },
		func() (common.Control, error) { return class.getCurrency(ticket) })...)...)

	return common.InitWidget(&BoardingPassWidget{}, class.mid(), &accum, ticket.ExpireDate())
}

func (class Class) makeTomorrowWidget(ticket Ticket) (common.Widget, error) {
	accum := common.Accumulator{}
	accum.Add(
		func() (common.Control, error) {
			return class.getLogo(ticket, common.LogoColorCfg, common.LogoIconRegular)
		},
		func() (common.Control, error) { return class.getTitle() })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getRoute(ticket) },
		func() (common.Control, error) { return class.getRouteAux(ticket) },
		func() (common.Control, error) { return class.getCheckin(ticket) },
		func() (common.Control, error) { return class.getTransfer(ticket) })...)
	accum.Add(common.SuppressError(common.Async(
		func() (common.Control, error) { return class.getWeather(ticket) },
		func() (common.Control, error) { return class.getCurrency(ticket) })...)...)

	return common.InitWidget(&FlightTomorrowWidget{}, class.mid(), &accum, ticket.ExpireDate())
}

func (class Class) makeFactlessWidget(ticket Ticket) (common.Widget, error) {
	accum := common.Accumulator{}
	accum.Add(
		func() (common.Control, error) {
			return class.getLogo(ticket, common.LogoColorDefault, common.LogoIconRegular)
		},
		func() (common.Control, error) { return class.getTitle() })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getGoToOrder(ticket) })...)
	return common.InitWidget(&FactlessAviaWidget{}, class.mid(), &accum, ticket.ExpireDate())
}

func (class Class) makeExpiredWidget(ticket Ticket) (common.Widget, error) {
	accum := common.Accumulator{}
	accum.Add(
		func() (common.Control, error) {
			return class.getLogo(ticket, common.LogoColorYa, common.LogoIconRegular)
		},
		func() (common.Control, error) { return class.getTitle() })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getShortRoute(ticket) },
		func() (common.Control, error) { return class.getShortRouteAux(ticket) })...)
	return common.InitWidget(&ExpiredTicketWidget{}, class.mid(), &accum, ticket.ExpireDate())
}

func (class Class) makeExpiredBoardingPassWidget(ticket Ticket) (common.Widget, error) {
	accum := common.Accumulator{}
	accum.Add(
		func() (common.Control, error) {
			return class.getLogo(ticket, common.LogoColorYa, common.LogoIconRegular)
		},
		func() (common.Control, error) { return class.getBoardingPassTitle() })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getRoute(ticket) },
		func() (common.Control, error) { return class.getRouteAux(ticket) })...)
	return common.InitWidget(&ExpiredBoardingPassWidget{}, class.mid(), &accum, ticket.ExpireDate())
}
