package bigimage

import (
	"a.yandex-team.ru/mail/iex/taksa/iex"
	"a.yandex-team.ru/mail/iex/taksa/logger"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
)

type Class struct {
	Cfg    Config
	Fact   iex.Fact
	Logger logger.Interface
}

type Error string

func (e Error) Error() string {
	return "bigimage error: " + string(e)
}

type BigImageType struct{}

func (BigImageType) Type() string { return "bigimage" }

type BigImageSubType struct{}

func (BigImageSubType) SubType() string { return "bigimage" }

type BigImageWidget struct {
	common.WidgetBase
	common.ValidTrue
	BigImageType
	BigImageSubType
}

type BigImageWidgetSingle struct {
	BigImageWidget
	common.SingleRowSize
}

type BigImageWidgetDouble struct {
	BigImageWidget
	common.DoubleRowSize
}

func (class Class) Name() string { return BigImageWidget{}.Type() }

func (class Class) mid() string { return class.Fact.Envelope.Mid }

func (class Class) Extend() (w common.Widget, error error) {
	fact, err := class.getIexBigImage()
	if err != nil {
		class.Logger.ErrorExtra(class.Name(), "iex big image convertion failed", logger.Extra{"err": err.Error()})
		return nil, err
	}

	id, err := fact.getID()
	if err != nil {
		class.Logger.Error(class.Name(), "no id in iex")
		return nil, err
	}
	version, err := fact.getVersion()
	if err != nil {
		class.Logger.Error(class.Name(), "no version in iex")
		return nil, err
	}

	value, err := fact.getValue()
	if err != nil {
		class.Logger.Error(class.Name(), "no value (service link) in iex")
		return nil, err
	}
	button, err := fact.getButton()
	if err != nil {
		class.Logger.Error(class.Name(), "no button link in iex")
		return nil, err
	}
	image, err := fact.getImage()
	if err != nil {
		class.Logger.Info(class.Name(), "no image link in iex")
	}

	if fact.getDouble() {
		w = &BigImageWidgetDouble{}
	} else {
		w = &BigImageWidgetSingle{}
	}
	control := common.MakeBigImageControl(value, button, image)
	w.Init(class.Fact.Envelope.Mid, []common.Control{control}, nil, id, version)
	return
}
