package bigimage

import "a.yandex-team.ru/mail/iex/taksa/widgets/common"

type BigImage struct {
	common.IexDict
}

func (class Class) getIexBigImage() (res BigImage, err error) {
	for _, f := range class.Fact.IEX {
		dict, ok := f.(map[string]interface{})
		res = BigImage{dict}
		if ok && res.GetSomething("taksa_widget_type_1234543456546") == "bigimage" {
			return
		}
	}
	return BigImage{}, Error("no big image in iex")
}

func (image BigImage) getID() (string, error) {
	return image.GetNonEmptyString("id")
}

func (image BigImage) getVersion() (string, error) {
	return image.GetNonEmptyString("version")
}

func (image BigImage) getValue() (string, error) {
	return image.GetNonEmptyString("value")
}

func (image BigImage) getButton() (string, error) {
	return image.GetNonEmptyString("button")
}

func (image BigImage) getImage() (string, error) {
	return image.GetString("image")
}

func (image BigImage) getDouble() bool {
	if b, ok := image.GetSomething("double").(bool); ok {
		return b
	}
	return false
}
