package bounce

import (
	"a.yandex-team.ru/mail/iex/taksa/iex"
	"a.yandex-team.ru/mail/iex/taksa/logger"
	"a.yandex-team.ru/mail/iex/taksa/request"
	"a.yandex-team.ru/mail/iex/taksa/tanker"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
)

type Class struct {
	Cfg     Config
	Fact    iex.Fact
	Logger  logger.Interface
	Request request.Request
	Tanker  tanker.Interface
}

func (class Class) Name() string {
	return BounceWidget{}.Type()
}

type Error string

func (e Error) Error() string {
	return "bounce error: " + string(e)
}

func (class Class) Extend() (common.Widget, error) {
	bounce, err := class.getBounce()
	if err != nil {
		class.Logger.ErrorExtra(class.Name(), "iex bounce convertion failed", logger.Extra{"err": err.Error()})
		return nil, err
	}
	subtype := bounce.subtype()
	switch subtype.(type) {
	case SuccessSubType:
		return class.makeSuccessWidget(bounce)
	case IPBlockedSubType:
		return class.makeIPBlockedWidget(bounce)
	case DmarcSubType:
		return class.makeDmarcWidget(bounce)
	case OtherSubType:
		return class.makeOtherWidget(bounce)
	case TrivialSubType:
		return class.makeTrivialWidget(bounce)
	}
	return nil, err
}

func (class Class) mid() string { return class.Fact.Envelope.Mid }
