package bounce

import (
	"a.yandex-team.ru/mail/iex/taksa/experiments"
	"a.yandex-team.ru/mail/iex/taksa/types"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
)

type Config struct {
	Types            types.Types             `json:"types"`
	Experiments      experiments.Experiments `json:"experiments"`
	LogoSuccess      common.LogoCfg          `json:"logo_success"`
	LogoFaiure       common.LogoCfg          `json:"logo_failure"`
	IconColorFailure string                  `json:"icon_color_failure"`
	IconColorSuccess string                  `json:"icon_color_success"`
	FaqLinkMask      string                  `json:"faq_link_mask"`
}

func Default() Config {
	return Config{
		LogoSuccess: common.DefaultLogoCfg(),
		LogoFaiure:  common.DefaultLogoCfg(),
	}
}

func (config Config) GetUnfilledMandatoryFields() (fields []string) {
	if len(config.Types) == 0 {
		fields = append(fields, "bounce.types")
	}
	if len(config.FaqLinkMask) == 0 {
		fields = append(fields, "bounce.faq_link_mask")
	}
	fields = append(fields, config.LogoSuccess.GetUnfilledMandatoryFields()...)
	fields = append(fields, config.LogoFaiure.GetUnfilledMandatoryFields()...)
	return
}

func (config Config) GetTypes() types.Types {
	return config.Types
}

func (config Config) GetExperiments() experiments.Experiments {
	return config.Experiments
}
