package bounce

import (
	"a.yandex-team.ru/mail/iex/taksa/tanker"
	"a.yandex-team.ru/mail/iex/taksa/tutil"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
	"fmt"
)

func (class Class) mxs(from string) (res string) {
	domain, _ := tutil.DomainFromEmail(from)
	res, _ = class.Tanker.GetMXS(domain)
	return
}

func (class Class) getLogo(lcfg common.LogoCfg, icon common.LogoIconF) (c common.Control, err error) {
	logo := common.Logo{Cfg: lcfg}
	text := class.mxs(class.Fact.Envelope.FromAddress)
	return common.MakeLogoControl(text, icon(logo), common.LogoColorDefault(logo), logo.Cfg.Zubchiki), nil
}

func (class Class) getSuccessLogo(bounce Bounce) (c common.Control, err error) {
	return class.getLogo(class.Cfg.LogoSuccess, common.LogoIconBright)
}

func (class Class) getFailureLogo(bounce Bounce) (c common.Control, err error) {
	return class.getLogo(class.Cfg.LogoFaiure, common.LogoIconBright)
}

func (class Class) getGrayLogo(bounce Bounce) (c common.Control, err error) {
	return class.getLogo(class.Cfg.LogoFaiure, common.LogoIconRegular)
}

func (class Class) getSuccessTitle(bounce Bounce) (c common.Control, err error) {
	text, _ := class.Tanker.GetSuccessBounce(bounce.recipients())
	c = common.MakeTitleControl(text)
	return
}

func (class Class) getIPBlockedTitle(bounce Bounce) (c common.Control, err error) {
	text, _ := class.Tanker.GetIPBlockedBounce(bounce.recipients())
	c = common.MakeTitleControl(text)
	return
}

func (class Class) getDmarcTitle(bounce Bounce) (c common.Control, err error) {
	from, err := bounce.originalFrom()
	if err == nil {
		text, _ := class.Tanker.GetDmarcBounce(from)
		c = common.MakeTitleControl(text)
	}
	return
}

func (class Class) getFailureTitle(bounce Bounce) (c common.Control, err error) {
	var text string
	switch bounce.bounceTypeRaw() {
	case "1":
		text, _ = class.Tanker.GetType1Bounce(bounce.recipients())
	case "2":
		text, _ = class.Tanker.GetType2Bounce(bounce.recipients())
	case "3":
		text, _ = class.Tanker.GetType3Bounce(bounce.recipients())
	case "4":
		text, _ = class.Tanker.GetType4Bounce(bounce.recipients())
	case "5":
		text, _ = class.Tanker.GetType5Bounce(bounce.recipients())
	case "6":
		text, _ = class.Tanker.GetType6Bounce(bounce.recipients())
	case "8":
		text, _ = class.Tanker.GetType8Bounce(bounce.recipients())
	}
	c = common.MakeTitleControl(text)
	return
}

func (class Class) getSubjectTitle() (c common.Control, err error) {
	c = common.MakeTitleControl(class.Fact.Envelope.Subject)
	return
}

func (class Class) getEmptyDescription() (c common.Control, err error) {
	c = common.MakeTextControl(common.Description1, "")
	return
}

func (class Class) getFirstlineDescription() (c common.Control, err error) {
	c = common.MakeTextControl(common.Description1, class.Fact.Envelope.Firstline)
	return
}

func (class Class) getDelAction() (c common.Control, err error) {
	return common.GetDelete(common.Action1, class.Tanker)
}

func (class Class) getFaqLink() (c common.Control, err error) {
	text, _ := class.Tanker.GetString(tanker.Faq)
	tld := class.Request.GetTld()
	c = common.MakeLinkControl(common.Action2, text, fmt.Sprintf(class.Cfg.FaqLinkMask, tld))
	return
}

func (class Class) getComposeAction(bounce Bounce) (c common.Control, err error) {
	text, _ := class.Tanker.GetString(tanker.Compose)
	mid, err := bounce.originalMid()
	if err != nil {
		return
	}
	c = common.MakeComposeControl(common.Action2, text, mid, bounce.needToFixRcpt())
	return
}
