package bounce

import (
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
	"strings"
)

type Bounce struct {
	common.IexDict
}

func (class Class) getBounce() (res Bounce, err error) {
	for _, f := range class.Fact.IEX {
		dict, ok := f.(map[string]interface{})
		if ok {
			res = Bounce{dict}
			return
		}
	}
	return
}

func (bounce Bounce) bounceTypeRaw() (res string) {
	res, _ = bounce.GetString("bounce_type")
	return
}

func (bounce Bounce) subtype() common.SubType {
	bounceType := bounce.bounceTypeRaw()
	switch bounceType {
	case "1", "3", "4", "5", "6", "8":
		return OtherSubType{}
	case "2":
		if bounce.isDmark() {
			return DmarcSubType{}
		} else {
			return OtherSubType{}
		}
	case "7":
		return IPBlockedSubType{}
	case "9":
		return SuccessSubType{}
	default:
		return TrivialSubType{}
	}
}

func (bounce Bounce) isDmark() bool {
	reason, _ := bounce.GetString("diagnostic_code")
	return strings.Contains(reason, "DMARC") ||
		strings.Contains(reason, "535 Authentication failed")
}

func (bounce Bounce) needToFixRcpt() bool {
	bounceType := bounce.bounceTypeRaw()
	return bounceType == "1" || bounceType == "5"
}

func (bounce Bounce) recipients() []string {
	rcpt, _ := common.GetStringSlice(bounce.GetSomething("final_recipient"))
	return rcpt
}

func (bounce Bounce) originalMid() (mid string, err error) {
	return bounce.GetNonEmptyString("original_mid")
}

func (bounce Bounce) originalFrom() (mid string, err error) {
	return bounce.GetNonEmptyString("original_from")
}
