package bounce

import "a.yandex-team.ru/mail/iex/taksa/widgets/common"

type BounceWidget struct{}

func (BounceWidget) Type() string { return "bounce" }

type SuccessSubType struct{}

func (SuccessSubType) SubType() string { return "success" }

type IPBlockedSubType struct{}

func (IPBlockedSubType) SubType() string { return "ip_blocked" }

type DmarcSubType struct{}

func (DmarcSubType) SubType() string { return "dmarc" }

type OtherSubType struct{}

func (OtherSubType) SubType() string { return "other" }

type TrivialSubType struct{}

func (TrivialSubType) SubType() string { return "trivial" }

type BasicBounceWidget struct {
	common.WidgetBase
	common.ValidTrue
	common.SingleRowSize
	BounceWidget
}

type SuccessBounceWidget struct {
	BasicBounceWidget
	SuccessSubType
}

type IPBlockedBounceWidget struct {
	BasicBounceWidget
	IPBlockedSubType
}

type DmarcBounceWidget struct {
	BasicBounceWidget
	DmarcSubType
}

type OtherBounceWidget struct {
	BasicBounceWidget
	OtherSubType
}

type TrivialBounceWidget struct {
	BasicBounceWidget
	TrivialSubType
}

func (class Class) makeSuccessWidget(bounce Bounce) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) { return class.getSuccessLogo(bounce) })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getSuccessTitle(bounce) },
		func() (common.Control, error) { return class.getEmptyDescription() },
		func() (common.Control, error) { return class.getDelAction() })...)
	return common.InitWidget(&SuccessBounceWidget{}, class.mid(), &accum, nil)
}

func (class Class) makeIPBlockedWidget(bounce Bounce) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) { return class.getFailureLogo(bounce) })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getIPBlockedTitle(bounce) },
		func() (common.Control, error) { return class.getEmptyDescription() },
		func() (common.Control, error) { return class.getDelAction() })...)
	return common.InitWidget(&IPBlockedBounceWidget{}, class.mid(), &accum, nil)
}

func (class Class) makeDmarcWidget(bounce Bounce) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) { return class.getFailureLogo(bounce) })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getDmarcTitle(bounce) },
		func() (common.Control, error) { return class.getEmptyDescription() },
		func() (common.Control, error) { return class.getDelAction() },
		func() (common.Control, error) { return class.getFaqLink() })...)
	return common.InitWidget(&DmarcBounceWidget{}, class.mid(), &accum, nil)
}

func (class Class) makeOtherWidget(bounce Bounce) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) { return class.getFailureLogo(bounce) })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getFailureTitle(bounce) },
		func() (common.Control, error) { return class.getEmptyDescription() },
		func() (common.Control, error) { return class.getComposeAction(bounce) },
		func() (common.Control, error) { return class.getDelAction() })...)
	return common.InitWidget(&OtherBounceWidget{}, class.mid(), &accum, nil)
}

func (class Class) makeTrivialWidget(bounce Bounce) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) { return class.getGrayLogo(bounce) })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getSubjectTitle() },
		func() (common.Control, error) { return class.getFirstlineDescription() },
		func() (common.Control, error) { return class.getDelAction() })...)
	return common.InitWidget(&TrivialBounceWidget{}, class.mid(), &accum, nil)
}
