package calendar

import (
	"a.yandex-team.ru/mail/iex/taksa/iex"
	"a.yandex-team.ru/mail/iex/taksa/logger"
	"a.yandex-team.ru/mail/iex/taksa/request"
	"a.yandex-team.ru/mail/iex/taksa/tanker"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
)

type Class struct {
	Cfg     Config
	Fact    iex.Fact
	Logger  logger.Interface
	Request request.Request
	Tanker  tanker.Interface
}

type Error string

func (e Error) Error() string {
	return "calendar error: " + string(e)
}

func (class Class) Name() string { return CalendarWidget{}.Type() }

func (class Class) mid() string { return class.Fact.Envelope.Mid }

func (class Class) Extend() (common.Widget, error) {
	event, err := class.getEvent()
	if err != nil {
		class.Logger.ErrorExtra(class.Name(), "iex event convertion failed", logger.Extra{"err": err.Error()})
		return nil, err
	}
	org, _ := event.GetOrganizer()
	to := ""
	if len(class.Fact.Envelope.ToAddresses) == 1 {
		to = class.Fact.Envelope.ToAddresses[0]
	}
	if class.Request.GetMobile() && to != "" && org.email == to {
		class.Logger.Info(class.Name(), "ignore calendar widget for organizer for mobile")
		return nil, nil
	}

	switch {
	case event.HasNoTitle():
		return class.makeDeclinedWidget(event)
	case event.IsCancelled():
		return class.makeCancelledWidget(event)
	case event.IsPast() || event.Subtype() == "calendar-updated":
		return class.makePastWidget(event)
	case event.IsUpdated():
		return class.makeUpdatedWidget(event)
	default:
		return class.makeNewWidget(event)
	}
}
