package calendar

import (
	"a.yandex-team.ru/mail/iex/taksa/tanker"
	"a.yandex-team.ru/mail/iex/taksa/tutil"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
	"fmt"
	"time"
)

func (class Class) getLogo() (c common.Control, err error) {
	return common.MakeLogoControl(class.Fact.Envelope.FromDisplayName, "", class.Cfg.Logo.LogoColorDefault, class.Cfg.Logo.Zubchiki), nil
}

func (class Class) getTitle(event Event) (c common.Control, err error) {
	title, _ := event.Title()
	c = common.MakeTitleControl(title)
	return
}

func (class Class) getTitleUpdated(event Event) (c common.Control, err error) {
	title, _ := event.Title()
	updated, _ := class.Tanker.GetString(tanker.Updated)
	c = common.MakeTitleControl(updated + ": " + title)
	return
}

func (class Class) getTitleCancelled(event Event) (c common.Control, err error) {
	title, _ := event.Title()
	cancelled, _ := class.Tanker.GetCancelledEvent(title)
	c = common.MakeTitleControl(cancelled)
	return
}

func (class Class) getTime(event Event, cancelled bool) string {
	nilTime := time.Time{}
	start, _ := tutil.GetTimeFromRfcString(event.GetSomething("start_date_rfc"))
	end, _ := tutil.GetTimeFromRfcString(event.GetSomething("end_date_rfc"))
	times := ""
	if start != nilTime && end != nilTime {
		times = class.Tanker.GetTimeInterval(start, end)
	}
	date := ""
	if start != nilTime {
		day, e1 := class.Tanker.GetDay(start)
		dateMonth, e2 := class.Tanker.GetDate(start)
		if e1 == nil && e2 == nil {
			date = fmt.Sprintf("%v, %v", dateMonth, day)
		}
	}

	free := ""
	if cancelled {
		free, _ = class.Tanker.GetString(tanker.FreeTime)
	}

	switch {
	case event.IsRepeatable() && event.IsAllDay():
		return fmt.Sprintf("&repeatable;%v %v", free, event.GetRepetition())
	case event.IsRepeatable() && !event.IsAllDay():
		return fmt.Sprintf("&repeatable;%v %v, %v", free, times, event.GetRepetition())
	case !event.IsRepeatable() && event.IsAllDay():
		return fmt.Sprintf("%v%v", free, date)
	case times != "" && date != "":
		return fmt.Sprintf("%v%v, %v", free, date, times)
	case date != "":
		return free + date
	default:
		return ""
	}
}

func getLocation(event Event) string {
	if locStr, ok := event.GetSomething("location").(string); ok {
		return locStr
	}
	if locStruct, ok := event.GetSomething("location").(map[string]interface{}); ok {
		if locName, ok := locStruct["name"].(string); ok {
			return locName
		}
	}
	return ""
}

func (class Class) getDescription(event Event, cancelled bool) (c common.Control, err error) {
	when := class.getTime(event, cancelled)
	where := getLocation(event)

	str := ""
	if when != "" && where != "" {
		str = when + ", " + where
	} else {
		str = when + where
	}
	c = common.MakeTextControlWithHTMLEntities(common.Description1, str)
	return
}

func (class Class) getParticipants(event Event) (c common.Control, err error) {
	people := ""
	cnt, e := event.People()
	if e != nil {
		people = "&man;&man;"
	} else {
		people = fmt.Sprintf("%v&nbsp;&man;&man;", cnt)
	}

	participants := []common.Participant{}

	org, e := event.GetOrganizer()
	if e == nil {
		participants = append(participants, common.Participant{Status: "&organizer;", Name: org.name, Address: org.email})
	}

	for _, participant := range event.GetParticipants() {
		status := ""
		switch participant.decision {
		case "undecided":
			status = "&undecided;"
		case "accepted":
			status = "&accepted;"
		case "declined":
			status = "&declined;"
		}
		participants = append(participants, common.Participant{Status: status, Name: participant.name, Address: participant.email})
	}
	c = common.MakeDropControl(common.Action1, people, participants)
	return
}

func (class Class) makeWillGoButton(event Event, goGoState int, yellow bool) common.SingleButton {
	str, _ := class.Tanker.GetString(tanker.WillGo)
	return common.SingleButton{
		Label:             str,
		Value:             "calendar_accept",
		Type:              common.Button,
		ExternalEventID:   event.ExternalEventID(),
		RecurrenceEventID: event.RecurrenceEventID(),
		GoToState:         goGoState,
		Yellow:            yellow,
	}
}

func (class Class) makeWillNotGoButton(event Event, goGoState int) common.SingleButton {
	str, _ := class.Tanker.GetString(tanker.WillNotGo)
	return common.SingleButton{
		Label:             str,
		Value:             "calendar_decline",
		Type:              common.Button,
		ExternalEventID:   event.ExternalEventID(),
		RecurrenceEventID: event.RecurrenceEventID(),
		GoToState:         goGoState,
	}
}

func (class Class) makeLookButton(event Event, goGoState int) common.SingleButton {
	url, _ := event.LookURL()
	str, _ := class.Tanker.GetString(tanker.Look)
	return common.SingleButton{
		Label:     str,
		Value:     url,
		Type:      common.Link,
		GoToState: goGoState,
	}
}

func (class Class) getButtons(event Event) (c common.Control, err error) {
	states := []common.ButtonState{}
	decision, _ := event.Decision()
	org, _ := event.GetOrganizer()
	to := ""
	if len(class.Fact.Envelope.ToAddresses) == 1 {
		to = class.Fact.Envelope.ToAddresses[0]
	}
	switch {
	case org.email == to && to != "":
		states = []common.ButtonState{{ID: 1, ButtonsInState: []common.SingleButton{class.makeLookButton(event, 1)}}}
	case decision == "undecided":
		state1 := common.ButtonState{ID: 1, ButtonsInState: []common.SingleButton{class.makeWillGoButton(event, 2, true), class.makeWillNotGoButton(event, 3)}}
		state2 := common.ButtonState{ID: 2, ButtonsInState: []common.SingleButton{class.makeWillNotGoButton(event, 3), class.makeLookButton(event, 2)}}
		state3 := common.ButtonState{ID: 3, ButtonsInState: []common.SingleButton{class.makeWillGoButton(event, 2, false), class.makeLookButton(event, 3)}}
		states = []common.ButtonState{state1, state2, state3}
	case decision == "accepted":
		state1 := common.ButtonState{ID: 1, ButtonsInState: []common.SingleButton{class.makeWillNotGoButton(event, 2), class.makeLookButton(event, 1)}}
		state2 := common.ButtonState{ID: 2, ButtonsInState: []common.SingleButton{class.makeWillGoButton(event, 1, false), class.makeLookButton(event, 2)}}
		states = []common.ButtonState{state1, state2}
	case decision == "declined":
		state1 := common.ButtonState{ID: 1, ButtonsInState: []common.SingleButton{class.makeWillGoButton(event, 2, false), class.makeLookButton(event, 1)}}
		state2 := common.ButtonState{ID: 2, ButtonsInState: []common.SingleButton{class.makeWillNotGoButton(event, 1), class.makeLookButton(event, 2)}}
		states = []common.ButtonState{state1, state2}
	}
	c = common.MakeButtonsControl(common.Action2, states)
	return
}
