package calendar

import "a.yandex-team.ru/mail/iex/taksa/widgets/common"

type CalendarWidget struct{}

func (CalendarWidget) Type() string { return "calendar" }

type NewSubType struct{}

func (NewSubType) SubType() string { return "new" }

type UpdatedSubType struct{}

func (UpdatedSubType) SubType() string { return "updated" }

type PastSubType struct{}

func (PastSubType) SubType() string { return "past" }

type CancelledSubType struct{}

func (CancelledSubType) SubType() string { return "cancelled" }

type DeclinedSubType struct{}

func (DeclinedSubType) SubType() string { return "declined" }

type BasicCalendarWidget struct {
	common.WidgetBase
	common.SingleRowSize
	CalendarWidget
}

type NewCalendarWidget struct {
	BasicCalendarWidget
	common.ValidTrue
	NewSubType
}

type UpdatedCalendarWidget struct {
	BasicCalendarWidget
	common.ValidTrue
	UpdatedSubType
}

type PastCalendarWidget struct {
	BasicCalendarWidget
	common.ValidFalse
	PastSubType
}

type CancelledCalendarWidget struct {
	BasicCalendarWidget
	common.ValidFalse
	CancelledSubType
}

type DeclinedCalendarWidget struct {
	BasicCalendarWidget
	common.ValidFalse
	DeclinedSubType
}

func (class Class) makeNewWidget(event Event) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) { return class.getLogo() })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getTitle(event) },
		func() (common.Control, error) { return class.getDescription(event, false) },
		func() (common.Control, error) { return class.getParticipants(event) },
		func() (common.Control, error) { return class.getButtons(event) })...)
	return common.InitWidget(&NewCalendarWidget{}, class.mid(), &accum, nil)
}

func (class Class) makeUpdatedWidget(event Event) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) { return class.getLogo() })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getTitleUpdated(event) },
		func() (common.Control, error) { return class.getDescription(event, false) },
		func() (common.Control, error) { return class.getParticipants(event) },
		func() (common.Control, error) { return class.getButtons(event) })...)
	return common.InitWidget(&UpdatedCalendarWidget{}, class.mid(), &accum, nil)
}

func (class Class) makeDeclinedWidget(event Event) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) { return class.getLogo() })
	return common.InitWidget(&DeclinedCalendarWidget{}, class.mid(), &accum, nil)
}

func (class Class) makeCancelledWidget(event Event) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) { return class.getLogo() })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getTitleCancelled(event) },
		func() (common.Control, error) { return class.getDescription(event, true) })...)
	return common.InitWidget(&CancelledCalendarWidget{}, class.mid(), &accum, nil)
}

func (class Class) makePastWidget(event Event) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) { return class.getLogo() })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getTitle(event) },
		func() (common.Control, error) { return class.getDescription(event, false) })...)
	return common.InitWidget(&PastCalendarWidget{}, class.mid(), &accum, nil)
}
