package widgets

import (
	"a.yandex-team.ru/mail/iex/taksa/client"
	"a.yandex-team.ru/mail/iex/taksa/experiments"
	"a.yandex-team.ru/mail/iex/taksa/iex"
	"a.yandex-team.ru/mail/iex/taksa/logger"
	"a.yandex-team.ru/mail/iex/taksa/meta"
	"a.yandex-team.ru/mail/iex/taksa/request"
	"a.yandex-team.ru/mail/iex/taksa/tanker"
	"a.yandex-team.ru/mail/iex/taksa/widgets/avia"
	"a.yandex-team.ru/mail/iex/taksa/widgets/bigimage"
	"a.yandex-team.ru/mail/iex/taksa/widgets/bounce"
	"a.yandex-team.ru/mail/iex/taksa/widgets/calendar"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
	"a.yandex-team.ru/mail/iex/taksa/widgets/eshop"
	"a.yandex-team.ru/mail/iex/taksa/widgets/hotels"
	"a.yandex-team.ru/mail/iex/taksa/widgets/onelink"
	"a.yandex-team.ru/mail/iex/taksa/widgets/pkpass"
	"a.yandex-team.ru/mail/iex/taksa/widgets/snippet"
	"a.yandex-team.ru/mail/iex/taksa/widgets/spam"
	"a.yandex-team.ru/mail/iex/taksa/widgets/tracker"
	"a.yandex-team.ru/mail/iex/taksa/widgets/urlinfo"
	"a.yandex-team.ru/mail/iex/taksa/widgets/yandexpayment"
)

type Class interface {
	Name() string
	Extend() (common.Widget, error)
}

func (w Widgets) Widgetable(all []meta.Envelope) (res []meta.Envelope) {
	for _, envelope := range all {
		if w.Cfg.GetAllTypes().Fits(envelope.Types) {
			res = append(res, envelope)
		}
	}
	return
}

func (w Widgets) classify(cfg Config, fact iex.Fact, l logger.Interface, c client.Interface, r request.Interface) (classes []Class) {
	req := request.RequestImpl{Req: r, DefaultTLD: cfg.DefaultTLD}
	headerExp := r.GetHeader("X-Yandex-Enabledexpboxes")
	userExps, err := experiments.ParseHeader(headerExp)
	if err != nil {
		l.Error("widgets", err.Error())
	}

	if isWidgetEnabled(w.Cfg.Spam, fact, userExps) {
		classes = append(classes, spam.Class{
			Cfg:    cfg.Spam,
			Fact:   fact,
			Logger: l,
			Tanker: tanker.GetInstance(tanker.DefaultLocale)})
	}
	if isWidgetEnabled(w.Cfg.YandexPayment, fact, userExps) {
		classes = append(classes, yandexpayment.Class{
			Cfg:    cfg.YandexPayment,
			Fact:   fact,
			Logger: l})
	}
	if len(fact.IEX) == 0 {
		return
	}
	if isWidgetEnabled(w.Cfg.Hotels, fact, userExps) {
		classes = append(classes, hotels.Class{
			Cfg:     cfg.Hotels,
			Fact:    fact,
			Logger:  l,
			Client:  c,
			Request: req,
			Tanker:  tanker.GetInstance(tanker.DefaultLocale)})
	}
	if isWidgetEnabled(w.Cfg.Avia, fact, userExps) {
		classes = append(classes, avia.Class{
			Cfg:     cfg.Avia,
			Fact:    fact,
			Logger:  l,
			Client:  c,
			Request: req,
			Tanker:  tanker.GetInstance(tanker.DefaultLocale)})
	}
	if isWidgetEnabled(w.Cfg.Calendar, fact, userExps) {
		classes = append(classes, calendar.Class{
			Cfg:     cfg.Calendar,
			Fact:    fact,
			Logger:  l,
			Request: req,
			Tanker:  tanker.GetInstance(tanker.DefaultLocale)})
	}
	if isWidgetEnabled(w.Cfg.Pkpass, fact, userExps) {
		classes = append(classes, pkpass.Class{
			Cfg:    cfg.Pkpass,
			Fact:   fact,
			Logger: l,
			Tanker: tanker.GetInstance(tanker.DefaultLocale)})
	}
	if isWidgetEnabled(w.Cfg.Bounce, fact, userExps) {
		classes = append(classes, bounce.Class{
			Cfg:     cfg.Bounce,
			Fact:    fact,
			Logger:  l,
			Request: req,
			Tanker:  tanker.GetInstance(tanker.DefaultLocale)})
	}
	if isWidgetEnabled(w.Cfg.Eshop, fact, userExps) {
		classes = append(classes, eshop.Class{
			Cfg:    cfg.Eshop,
			Fact:   fact,
			Logger: l,
			Tanker: tanker.GetInstance(tanker.DefaultLocale)})
	}
	if isWidgetEnabled(w.Cfg.Tracker, fact, userExps) {
		classes = append(classes, tracker.Class{
			Cfg:    cfg.Tracker,
			Fact:   fact,
			Logger: l})
	}
	if isWidgetEnabled(w.Cfg.OneLink, fact, userExps) {
		classes = append(classes, onelink.Class{
			Cfg:    cfg.OneLink,
			Fact:   fact,
			Logger: l,
			Tanker: tanker.GetInstance(tanker.DefaultLocale)})
	}
	if isWidgetEnabled(w.Cfg.Snippet, fact, userExps) {
		classes = append(classes, snippet.Class{
			Cfg:    cfg.Snippet,
			Fact:   fact,
			Logger: l})
	}
	if isWidgetEnabled(w.Cfg.URLInfo, fact, userExps) {
		classes = append(classes, urlinfo.Class{
			Cfg:    cfg.URLInfo,
			Fact:   fact,
			Logger: l,
		})
	}
	if isWidgetEnabled(w.Cfg.BigImage, fact, userExps) {
		classes = append(classes, bigimage.Class{
			Cfg:    cfg.BigImage,
			Fact:   fact,
			Logger: l,
		})
	}
	return
}

func isWidgetEnabled(conf common.WidgetConfig, fact iex.Fact, userExps experiments.Experiments) bool {
	return conf.GetTypes().Fits(fact.Envelope.Types) &&
		(len(conf.GetExperiments()) == 0 || userExps.ContainsOneOf(conf.GetExperiments()))
}
