package common

import (
	"a.yandex-team.ru/mail/iex/taksa/future"
)

type SuppressedError struct {
	Original error
}

func (e SuppressedError) Error() string {
	return "Seppressed error: " + e.Original.Error()
}

type functor func() (Control, error)

func (f functor) generic() future.Functor {
	return func() (interface{}, error) {
		return f()
	}
}

func generic(fs ...functor) (functors []future.Functor) {
	for _, f := range fs {
		functors = append(functors, f.generic())
	}
	return
}

func get(f future.Future) functor {
	return func() (Control, error) {
		c, e := f.Get()
		return c.(Control), e
	}
}

type Accumulator struct {
	functors []functor
}

func SuppressError(fs ...functor) (functors []functor) {
	for _, fref := range fs {
		f := fref //Yes, we need a COPY to capture it into functor
		functors = append(functors, func() (Control, error) {
			c, e := f()
			if e != nil {
				return c, SuppressedError{e}
			}
			return c, nil
		})
	}
	return
}

func Async(fs ...functor) (functors []functor) {
	for _, f := range generic(fs...) {
		functors = append(functors, get(f.Async()))
	}
	return
}

func (a *Accumulator) Add(f ...functor) {
	a.functors = append(a.functors, f...)
}

func (a *Accumulator) Result() (controls []Control, err error) {
	for _, f := range a.functors {
		c, e := f()
		if e == nil {
			controls = append(controls, c)
		} else if _, ok := e.(SuppressedError); !ok {
			err = e
			return
		}

	}
	return
}
