package common

import (
	"a.yandex-team.ru/mail/iex/taksa/tanker"
	"fmt"
	"strings"
)

const (
	space string = " "
)

type Attributes map[string]interface{}

type Control struct {
	Role       string      `json:"role"`
	Type       ControlType `json:"type"`
	Attributes Attributes  `json:"attributes"`
}

func GetPrint(role fmt.Stringer, parts []string, tnkr tanker.Interface) (c Control, err error) {
	text, err := tnkr.GetString(tanker.Print)
	if err != nil {
		return
	}
	c = MakePrintControl(role, text, strings.Join(parts, space))
	return
}

type stringGetter func() (string, error)

func GetLink(role fmt.Stringer, getLink stringGetter, key tanker.StringID, tnkr tanker.Interface) (c Control, err error) {
	text, err := tnkr.GetString(key)
	if err != nil {
		return
	}
	link, err := getLink()
	if err != nil {
		return
	}
	if link == "" {
		err = WidgetError("empty link")
		return
	}
	c = MakeLinkControl(role, text, link)
	return
}

func GetText(role fmt.Stringer, getText stringGetter) (c Control, err error) {
	text, err := getText()
	if err != nil {
		return
	}
	c = MakeTextControl(role, text)
	return
}

func GetDelete(role fmt.Stringer, tnkr tanker.Interface) (c Control, err error) {
	text, err := tnkr.GetString(tanker.Delete)
	if err != nil {
		return
	}
	c = MakeDeleteControl(role, text)
	return
}
