package common

import (
	"fmt"
	"reflect"
	"strconv"
	"strings"
)

func findLogo(controls []Control) *Control {
	for _, c := range controls {
		if c.Role == "logo" && c.Type == LogoT {
			return &c
		}
	}
	return nil
}

type HasLogo struct{}

func (hasLogo HasLogo) Match(i interface{}) bool {
	return findLogo(i.([]Control)) != nil
}

func (hasLogo HasLogo) String() string {
	return "has logo"
}

//######

type LogoLabelIs struct {
	Value           string
	HasHTMLEntities bool
}

func (logoLabelIs LogoLabelIs) Match(i interface{}) bool {
	c := findLogo(i.([]Control))
	return c != nil && c.Attributes["label"] == logoLabelIs.Value &&
		c.Attributes["has_html_entities"] == logoLabelIs.HasHTMLEntities
}

func (logoLabelIs LogoLabelIs) String() string {
	return fmt.Sprintf("logo label is %v, has_html_entities is %v", logoLabelIs.Value, logoLabelIs.HasHTMLEntities)
}

//######

type ZubchikiIs struct {
	Value bool
}

func (zubchikiIs ZubchikiIs) Match(i interface{}) bool {
	c := findLogo(i.([]Control))
	return c != nil && c.Attributes["zubchiki"] == zubchikiIs.Value
}

func (zubchikiIs ZubchikiIs) String() string {
	return "Zubchiki is " + strconv.FormatBool(zubchikiIs.Value)
}

//######

type LogoColorIs struct {
	Value string
}

func (logoColorIs LogoColorIs) Match(i interface{}) bool {
	c := findLogo(i.([]Control))
	return c != nil && c.Attributes["color"] == logoColorIs.Value
}

func (logoColorIs LogoColorIs) String() string {
	return "LogoColor is " + logoColorIs.Value
}

//######

type LogoIconIs struct {
	Value string
}

func (logoIconIs LogoIconIs) Match(i interface{}) bool {
	c := findLogo(i.([]Control))
	return c != nil && c.Attributes["icon"] == logoIconIs.Value
}

func (logoIconIs LogoIconIs) String() string {
	return "LogoIcon is " + logoIconIs.Value
}

//######

type HasDelete struct {
	Role string
}

func (hasDelete HasDelete) Match(i interface{}) bool {
	for _, c := range i.([]Control) {
		if c.Type == Delete {
			return c.Role == hasDelete.Role
		}
	}
	return false
}

func (hasDelete HasDelete) String() string {
	return "has control with type delete and role " + hasDelete.Role
}

//######

type TitleIs struct {
	Value           string
	HasHTMLEntities bool
}

func (titleIs TitleIs) Match(i interface{}) bool {
	for _, c := range i.([]Control) {
		if c.Type == Text && c.Role == "title" {
			return c.Attributes["label"] == titleIs.Value &&
				c.Attributes["has_html_entities"] == titleIs.HasHTMLEntities
		}
	}
	return false
}

func (titleIs TitleIs) String() string {
	return fmt.Sprintf("title is %v, has_html_entities is %v", titleIs.Value, titleIs.HasHTMLEntities)
}

//######

type TitleContains struct {
	Value           string
	HasHTMLEntities bool
}

func (titleContains TitleContains) Match(i interface{}) bool {
	for _, c := range i.([]Control) {
		if c.Type == Text && c.Role == "title" {
			return strings.Contains(c.Attributes["label"].(string), titleContains.Value) &&
				c.Attributes["has_html_entities"] == titleContains.HasHTMLEntities
		}
	}
	return false
}

func (titleContains TitleContains) String() string {
	return fmt.Sprintf("title contains %v, has_html_entities is %v", titleContains.Value, titleContains.HasHTMLEntities)
}

//######

type Description1Is struct {
	Value           string
	HasHTMLEntities bool
}

func (description1Is Description1Is) Match(i interface{}) bool {
	for _, c := range i.([]Control) {
		if c.Type == Text && c.Role == Description1.String() {
			return c.Attributes["label"] == description1Is.Value &&
				c.Attributes["has_html_entities"] == description1Is.HasHTMLEntities
		}
	}
	return false
}

func (description1Is Description1Is) String() string {
	return fmt.Sprintf("description-1 is %v, has_html_entities is %v", description1Is.Value, description1Is.HasHTMLEntities)
}

//######

type Description1AuxIs struct {
	Value           string
	HasHTMLEntities bool
}

func (description1AuxIs Description1AuxIs) Match(i interface{}) bool {
	for _, c := range i.([]Control) {
		if c.Type == Text && c.Role == Description1Aux.String() {
			return c.Attributes["label"] == description1AuxIs.Value &&
				c.Attributes["has_html_entities"] == description1AuxIs.HasHTMLEntities
		}
	}
	return false
}

func (description1AuxIs Description1AuxIs) String() string {
	return fmt.Sprintf("description-11 is %v, has_html_entities is %v", description1AuxIs.Value, description1AuxIs.HasHTMLEntities)
}

//######

type Description2Is struct {
	Value           string
	HasHTMLEntities bool
}

func (description2Is Description2Is) Match(i interface{}) bool {
	for _, c := range i.([]Control) {
		if c.Type == Text && c.Role == Description2.String() {
			return c.Attributes["label"] == description2Is.Value &&
				c.Attributes["has_html_entities"] == description2Is.HasHTMLEntities
		}
	}
	return false
}

func (description2Is Description2Is) String() string {
	return fmt.Sprintf("description-2 is %v, has_html_entities is %v", description2Is.Value, description2Is.HasHTMLEntities)
}

//######

type Description3Is struct {
	Value           string
	HasHTMLEntities bool
}

func (description3Is Description3Is) Match(i interface{}) bool {
	for _, c := range i.([]Control) {
		if c.Type == Text && c.Role == Description3.String() {
			return c.Attributes["label"] == description3Is.Value &&
				c.Attributes["has_html_entities"] == description3Is.HasHTMLEntities
		}
	}
	return false
}

func (description3Is Description3Is) String() string {
	return fmt.Sprintf("description-3 is %v, has_html_entities is %v", description3Is.Value, description3Is.HasHTMLEntities)
}

//######

type Special1Is struct {
	Value           string
	HasHTMLEntities bool
}

func (special1Is Special1Is) Match(i interface{}) bool {
	for _, c := range i.([]Control) {
		if c.Type == Text && c.Role == Special1.String() {
			return c.Attributes["label"] == special1Is.Value &&
				c.Attributes["has_html_entities"] == special1Is.HasHTMLEntities
		}
	}
	return false
}

func (special1Is Special1Is) String() string {
	return fmt.Sprintf("special-1 is %v, has_html_entities is %v", special1Is.Value, special1Is.HasHTMLEntities)
}

//######

type HasLink struct {
	Role            string
	Label           string
	Value           string
	HasHTMLEntities bool
}

func (hasLink HasLink) Match(i interface{}) bool {
	for _, c := range i.([]Control) {
		if c.Type == Link && c.Role == hasLink.Role {
			return c.Attributes["label"] == hasLink.Label && c.Attributes["value"] == hasLink.Value &&
				c.Attributes["has_html_entities"] == hasLink.HasHTMLEntities
		}
	}
	return false
}

func (hasLink HasLink) String() string {
	return fmt.Sprintf("has link with role=%v, label=%v, value=%v, has_html_entities=%v",
		hasLink.Role, hasLink.Label, hasLink.Value, hasLink.HasHTMLEntities)
}

//######

type HasImgLink struct {
	Role  string
	Label string
	Value string
}

func (hasImgLink HasImgLink) Match(i interface{}) bool {
	for _, c := range i.([]Control) {
		if c.Type == ImgLink && c.Role == hasImgLink.Role {
			return c.Attributes["label"] == hasImgLink.Label && c.Attributes["value"] == hasImgLink.Value
		}
	}
	return false
}

func (hasImgLink HasImgLink) String() string {
	return fmt.Sprintf("has imglink with role=%v, label=%v, value=%v", hasImgLink.Role, hasImgLink.Label, hasImgLink.Value)
}

//######

type HasCompose struct {
	Role string
}

func (hasCompose HasCompose) Match(i interface{}) bool {
	for _, c := range i.([]Control) {
		if c.Type == Compose {
			return c.Role == hasCompose.Role
		}
	}
	return false
}

func (hasCompose HasCompose) String() string {
	return "has control with type compose and role " + hasCompose.Role
}

//######

type HasPrint struct {
	Role  string
	Parts string
}

func (hasPrint HasPrint) Match(i interface{}) bool {
	for _, c := range i.([]Control) {
		if c.Type == Print && c.Role == hasPrint.Role {
			return c.Attributes["value"] == hasPrint.Parts
		}
	}
	return false
}

func (hasPrint HasPrint) String() string {
	return "has print with role " + hasPrint.Role + " and parts " + hasPrint.Parts
}

//######

type HasDrop struct {
	Role            string
	Label           string
	HasHTMLEntities bool
}

func (hasDrop HasDrop) Match(i interface{}) bool {
	for _, c := range i.([]Control) {
		if c.Type == Drop && c.Role == hasDrop.Role {
			return c.Attributes["label"] == hasDrop.Label &&
				c.Attributes["has_html_entities"] == hasDrop.HasHTMLEntities
		}
	}
	return false
}

func (hasDrop HasDrop) String() string {
	return fmt.Sprintf("has control with type drop, role=%v, label=%v, has_html_entities=%v",
		hasDrop.Role, hasDrop.Label, hasDrop.HasHTMLEntities)
}

//######

type ButtonsIs struct {
	Role string
}

func (buttonsIs ButtonsIs) Match(i interface{}) bool {
	for _, c := range i.([]Control) {
		if c.Type == Buttons && c.Role == buttonsIs.Role {
			return true
		}
	}
	return false
}

func (buttonsIs ButtonsIs) String() string {
	return "buttons have role " + buttonsIs.Role
}

//######

type HasRichPreview struct {
	Attributes Attributes
}

func (hasRichPreview HasRichPreview) Match(i interface{}) bool {
	for _, c := range i.([]Control) {
		if c.Type == RichPreviewLink && c.Role == "rich_preview" &&
			reflect.DeepEqual(c.Attributes, hasRichPreview.Attributes) {
			return true
		}
	}
	return false
}

func (hasRichPreview HasRichPreview) String() string {
	return fmt.Sprintf("has rich preview with attributes: %v", hasRichPreview.Attributes)
}

//######

type HasBigImage struct {
	Value  string
	Button string
	Image  string
}

func (hasBigImage HasBigImage) Match(i interface{}) bool {
	for _, c := range i.([]Control) {
		if c.Type == BigImageT && c.Role == "bigimage" {
			return c.Attributes["value"] == hasBigImage.Value &&
				c.Attributes["button"] == hasBigImage.Button &&
				c.Attributes["image"] == hasBigImage.Image
		}
	}
	return false
}

func (hasBigImage HasBigImage) String() string {
	return fmt.Sprintf("has bigimage with value: %v, button: %v, image: %v",
		hasBigImage.Value, hasBigImage.Button, hasBigImage.Image)
}
