package common

type ErrorIex string

func (e ErrorIex) Error() string {
	return "iex error: " + string(e)
}

type IexDict map[string]interface{}

func (dict IexDict) GetString(name string) (string, error) {
	if retval, ok := dict[name].(string); ok {
		return retval, nil
	}
	return "", ErrorIex(name + " cast error - string required")
}

func (dict IexDict) GetSomething(name string) interface{} {
	return dict[name]
}

func (dict IexDict) GetNonEmptyString(name string) (retval string, err error) {
	retval, err = dict.GetString(name)
	if err == nil && retval == "" {
		err = ErrorIex("empty " + name)
	}
	return
}

func GetInterfaceSlice(smth interface{}) ([]interface{}, error) {
	if retval, ok := smth.([]interface{}); ok {
		return retval, nil
	}
	return []interface{}{}, ErrorIex("cast error - []interface{} required")
}

func GetStringSlice(smth interface{}) (res []string, err error) {
	interfaceSlice, err := GetInterfaceSlice(smth)
	if err == nil {
		for _, i := range interfaceSlice {
			if s, ok := i.(string); ok {
				res = append(res, s)
			}
		}
	}
	return
}

func PrintParts(smth interface{}) (res []string) {
	parts, err := GetInterfaceSlice(smth)
	if err == nil {
		for _, part := range parts {
			if partStr, ok := part.(string); ok {
				res = append(res, partStr)
			}
		}
	}
	return
}
