package common

type LogoCfg struct {
	Zubchiki         bool              `json:"zubchiki"`
	LogoIconRegular  string            `json:"logo_icon_regular"`
	LogoIconBright   string            `json:"logo_icon_bright"`
	LogoColor        map[string]string `json:"logo_color"`
	LogoColorDefault string            `json:"logo_color_default"`
	LogoColorYa      string            `json:"logo_color_ya"`
	LogoName         map[string]string `json:"logo_name"`
}

func DefaultLogoCfg() LogoCfg {
	return LogoCfg{
		Zubchiki:    false,
		LogoColorYa: "#bebebe",
	}
}

func (cfg LogoCfg) GetUnfilledMandatoryFields() (fields []string) {
	if len(cfg.LogoColorDefault) == 0 {
		fields = append(fields, "logo_color_default")
	}
	return
}

type Logo struct {
	Cfg         LogoCfg
	Key         string
	DefaultName string
}

type LogoColorF func(Logo) string

func LogoColorCfg(l Logo) string {
	color := l.Cfg.LogoColor[l.Key]
	if color == "" {
		color = l.Cfg.LogoColorDefault
	}
	return color
}

func LogoColorYa(l Logo) string {
	return l.Cfg.LogoColorYa
}

func LogoColorDefault(l Logo) string {
	return l.Cfg.LogoColorDefault
}

type LogoIconF func(Logo) string

func LogoIconRegular(l Logo) string {
	return l.Cfg.LogoIconRegular
}

func LogoIconBright(l Logo) string {
	return l.Cfg.LogoIconBright
}

func LogoName(l Logo) string {
	name := l.Cfg.LogoName[l.Key]
	if name == "" {
		name = l.DefaultName
	}
	return name
}
