package widgets

import (
	"a.yandex-team.ru/mail/iex/taksa/tutil"
	"a.yandex-team.ru/mail/iex/taksa/types"
	"a.yandex-team.ru/mail/iex/taksa/widgets/avia"
	"a.yandex-team.ru/mail/iex/taksa/widgets/bigimage"
	"a.yandex-team.ru/mail/iex/taksa/widgets/bounce"
	"a.yandex-team.ru/mail/iex/taksa/widgets/calendar"
	"a.yandex-team.ru/mail/iex/taksa/widgets/eshop"
	"a.yandex-team.ru/mail/iex/taksa/widgets/hotels"
	"a.yandex-team.ru/mail/iex/taksa/widgets/onelink"
	"a.yandex-team.ru/mail/iex/taksa/widgets/pkpass"
	"a.yandex-team.ru/mail/iex/taksa/widgets/snippet"
	"a.yandex-team.ru/mail/iex/taksa/widgets/spam"
	"a.yandex-team.ru/mail/iex/taksa/widgets/tracker"
	"a.yandex-team.ru/mail/iex/taksa/widgets/urlinfo"
	"a.yandex-team.ru/mail/iex/taksa/widgets/yandexpayment"
	"fmt"
	"time"
)

type Config struct {
	Timeout       tutil.Timeout        `json:"timeout"`
	DefaultTLD    string               `json:"default_tld"`
	Avia          avia.Config          `json:"avia"`
	BigImage      bigimage.Config      `json:"bigimage"`
	Hotels        hotels.Config        `json:"hotels"`
	Pkpass        pkpass.Config        `json:"pkpass"`
	Bounce        bounce.Config        `json:"bounce"`
	OneLink       onelink.Config       `json:"onelink"`
	Eshop         eshop.Config         `json:"eshop"`
	Snippet       snippet.Config       `json:"snippet"`
	Tracker       tracker.Config       `json:"tracker"`
	Calendar      calendar.Config      `json:"calendar"`
	Spam          spam.Config          `json:"spam"`
	URLInfo       urlinfo.Config       `json:"url_info"`
	YandexPayment yandexpayment.Config `json:"yandex_payment"`
}

func (config Config) String() string {
	return fmt.Sprintf("widgets: avia, hotels, pkpass, bounce, onelink, eshop, snippet, tracker, calendar, spam, url_info, yandex_payment, bigimage (timeout=%v), widgetable = %v",
		time.Duration(config.Timeout), config.GetAllTypes().String())
}

func Default() Config {
	return Config{
		Timeout:       tutil.Timeout(time.Duration(1) * time.Second),
		DefaultTLD:    "ru",
		Avia:          avia.Default(),
		BigImage:      bigimage.Default(),
		Hotels:        hotels.Default(),
		Pkpass:        pkpass.Default(),
		Bounce:        bounce.Default(),
		OneLink:       onelink.Default(),
		Eshop:         eshop.Default(),
		Snippet:       snippet.Default(),
		Tracker:       tracker.Default(),
		Calendar:      calendar.Default(),
		Spam:          spam.Default(),
		URLInfo:       urlinfo.Default(),
		YandexPayment: yandexpayment.Default(),
	}
}

func (config Config) GetUnfilledMandatoryFields() (fields []string) {
	fields = append(fields, config.Avia.GetUnfilledMandatoryFields()...)
	fields = append(fields, config.BigImage.GetUnfilledMandatoryFields()...)
	fields = append(fields, config.Hotels.GetUnfilledMandatoryFields()...)
	fields = append(fields, config.Pkpass.GetUnfilledMandatoryFields()...)
	fields = append(fields, config.Bounce.GetUnfilledMandatoryFields()...)
	fields = append(fields, config.OneLink.GetUnfilledMandatoryFields()...)
	fields = append(fields, config.Eshop.GetUnfilledMandatoryFields()...)
	fields = append(fields, config.Snippet.GetUnfilledMandatoryFields()...)
	fields = append(fields, config.Tracker.GetUnfilledMandatoryFields()...)
	fields = append(fields, config.Calendar.GetUnfilledMandatoryFields()...)
	fields = append(fields, config.Spam.GetUnfilledMandatoryFields()...)
	fields = append(fields, config.URLInfo.GetUnfilledMandatoryFields()...)
	fields = append(fields, config.YandexPayment.GetUnfilledMandatoryFields()...)
	return
}

func (config Config) GetAllTypes() (res types.Types) {
	res = append(res, config.Avia.Types...)
	res = append(res, config.BigImage.Types...)
	res = append(res, config.Hotels.Types...)
	res = append(res, config.Pkpass.Types...)
	res = append(res, config.Bounce.Types...)
	res = append(res, config.OneLink.Types...)
	res = append(res, config.Eshop.Types...)
	res = append(res, config.Snippet.Types...)
	res = append(res, config.Tracker.Types...)
	res = append(res, config.Calendar.Types...)
	res = append(res, config.Spam.Types...)
	res = append(res, config.URLInfo.Types...)
	res = append(res, config.YandexPayment.Types...)
	return
}
