package eshop

import (
	"a.yandex-team.ru/mail/iex/taksa/iex"
	"a.yandex-team.ru/mail/iex/taksa/logger"
	"a.yandex-team.ru/mail/iex/taksa/meta"
	"a.yandex-team.ru/mail/iex/taksa/tanker"
	"a.yandex-team.ru/mail/iex/taksa/tutil"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
	"time"
)

type Class struct {
	Cfg    Config
	Fact   iex.Fact
	Logger logger.Interface
	Tanker tanker.Interface
}

type Error string

func (e Error) Error() string {
	return "eshop error: " + string(e)
}

func (class Class) Name() string { return EshopWidget{}.Type() }

func (class Class) mid() string { return class.Fact.Envelope.Mid }

func (class Class) Extend() (common.Widget, error) {
	order, err := class.getOrder()
	if err != nil {
		class.Logger.ErrorExtra(class.Name(), "iex order convertion failed", logger.Extra{"err": err.Error()})
		return nil, err
	}

	subtype, _ := order.Subtype()
	cancelled := order.IsCancelled()
	tooOld := isTooOld(class.Cfg.TTL, class.Cfg.TTLDefault, class.Fact.Envelope)
	switch {
	case subtype == "eshop" && !cancelled && !tooOld:
		return class.makeMainWidget(order)
	case subtype == "eshop" && (cancelled || tooOld):
		return class.makeOutdatedWidget(order)
	case subtype == "updated":
		return class.makeOutdatedWidget(order)
	default:
		class.Logger.ErrorExtra(class.Name(), "unsupported subtype", logger.Extra{"subtype": subtype})
		return nil, Error("unsupported subtype " + subtype)
	}
}

func isTooOld(ttlMap map[string]Days, ttlDefault Days, envelope meta.Envelope) bool {
	domain, _ := tutil.DomainFromEmail(envelope.FromAddress)
	ttl := ttlMap[domain]
	if ttl == 0 {
		ttl = ttlDefault
	}
	passedHours := time.Since(envelope.ReceivedDate).Hours()
	return int(passedHours) > int(ttl)*24
}
