package eshop

import (
	"a.yandex-team.ru/mail/iex/taksa/experiments"
	"a.yandex-team.ru/mail/iex/taksa/types"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
)

type Days int

type Config struct {
	Types       types.Types             `json:"types"`
	Experiments experiments.Experiments `json:"experiments"`
	Logo        common.LogoCfg          `json:"logo"`
	TTL         map[string]Days         `json:"ttl_days"`
	TTLDefault  Days                    `json:"ttl_days_default"`
}

func Default() Config {
	return Config{Logo: common.DefaultLogoCfg(), TTLDefault: 30}
}

func (config Config) GetUnfilledMandatoryFields() (fields []string) {
	if len(config.Types) == 0 {
		fields = append(fields, "eshop.types")
	}
	fields = append(fields, config.Logo.GetUnfilledMandatoryFields()...)
	return
}

func (config Config) GetTypes() types.Types {
	return config.Types
}

func (config Config) GetExperiments() experiments.Experiments {
	return config.Experiments
}
