package eshop

import (
	"a.yandex-team.ru/mail/iex/taksa/tanker"
	"a.yandex-team.ru/mail/iex/taksa/tutil"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
	"fmt"
)

func (class Class) getLogo(order Order, cf common.LogoColorF) (c common.Control, err error) {
	shop, _ := tutil.DomainFromEmail(class.Fact.Envelope.FromAddress)
	logo := common.Logo{Cfg: class.Cfg.Logo, Key: shop, DefaultName: class.Fact.Envelope.FromDisplayName}
	return common.MakeLogoControl(common.LogoName(logo), common.LogoIconRegular(logo), cf(logo), logo.Cfg.Zubchiki), nil
}

func (class Class) getTitle(order Order) (c common.Control, err error) {
	c = common.MakeTitleControl(class.Fact.Envelope.Subject)
	return
}

func (class Class) getDescription(order Order) (c common.Control, err error) {
	item, errI := order.Item()
	if errI == nil {
		var text string
		date, errD := order.DeliveryDate()
		if errD == nil {
			dateS, _ := class.Tanker.GetDate(date)
			text = fmt.Sprintf("%v &truck; %v", item, dateS)
		} else {
			text = item
		}
		c = common.MakeTextControlWithHTMLEntities(common.Description1, text)
	} else {
		c = common.MakeTextControl(common.Description1, class.Fact.Envelope.Firstline)
	}
	return
}

func (class Class) getLink(order Order) (c common.Control, err error) {
	return common.GetLink(common.Action1, order.Link, tanker.GoToOrder, class.Tanker)
}

func (class Class) getPrice(order Order) (c common.Control, err error) {
	return common.GetText(common.Description2, order.Price)
}
