package eshop

import (
	"a.yandex-team.ru/mail/iex/taksa/tutil"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
	"time"
)

type Order struct {
	common.IexDict
}

func (class Class) getOrder() (res Order, err error) {
	for _, f := range class.Fact.IEX {
		dict, ok := f.(map[string]interface{})
		res = Order{dict}
		if ok && res.GetSomething("taksa_widget_type_1234543456546") == "eshop" {
			return
		}
	}
	err = Error("no eshop in iex")
	return
}

func (order Order) Subtype() (string, error) {
	return order.GetString("widget_subtype")
}

func (order Order) Number() (string, error) {
	return order.GetNonEmptyString("order_number")
}

func (order Order) Status() (string, error) {
	return order.GetNonEmptyString("order_status")
}

func (order Order) IsCancelled() bool {
	status, _ := order.Status()
	return status == "OrderCancelled"
}

func (order Order) Item() (string, error) {
	return order.GetNonEmptyString("order")
}

func (order Order) DeliveryDate() (time.Time, error) {
	return tutil.GetTimeFromSomething(order.GetSomething("date_delivery"))
}

func (order Order) Link() (string, error) {
	return order.GetNonEmptyString("url")
}

func (order Order) Price() (string, error) {
	return order.GetNonEmptyString("price")
}
