package eshop

import "a.yandex-team.ru/mail/iex/taksa/widgets/common"

type EshopWidget struct{}

func (EshopWidget) Type() string { return "eshop" }

type MainSubType struct{}

func (MainSubType) SubType() string { return "order" }

type OutdatedSubType struct{}

func (OutdatedSubType) SubType() string { return "outdated" }

type BasicEshopWidget struct {
	common.WidgetBase
	common.SingleRowSize
	EshopWidget
}

type MainEshopWidget struct {
	BasicEshopWidget
	common.ValidTrue
	MainSubType
}

type OutdatedEshopWidget struct {
	BasicEshopWidget
	common.ValidFalse
	OutdatedSubType
}

func (class Class) makeMainWidget(order Order) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) { return class.getLogo(order, common.LogoColorCfg) })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getTitle(order) },
		func() (common.Control, error) { return class.getDescription(order) },
		func() (common.Control, error) { return class.getPrice(order) },
		func() (common.Control, error) { return class.getLink(order) })...)
	return common.InitWidget(&MainEshopWidget{}, class.mid(), &accum, nil)
}

func (class Class) makeOutdatedWidget(order Order) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) { return class.getLogo(order, common.LogoColorYa) })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getTitle(order) },
		func() (common.Control, error) { return class.getDescription(order) },
		func() (common.Control, error) { return class.getPrice(order) },
		func() (common.Control, error) { return class.getLink(order) })...)
	return common.InitWidget(&OutdatedEshopWidget{}, class.mid(), &accum, nil)
}
