package hotels

import (
	"a.yandex-team.ru/mail/iex/taksa/client"
	"a.yandex-team.ru/mail/iex/taksa/iex"
	"a.yandex-team.ru/mail/iex/taksa/logger"
	"a.yandex-team.ru/mail/iex/taksa/request"
	"a.yandex-team.ru/mail/iex/taksa/tanker"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
	"time"
)

type Class struct {
	Cfg     Config
	Fact    iex.Fact
	Logger  logger.Interface
	Client  client.Interface
	Request request.Request
	Tanker  tanker.Interface
}

func (class Class) Name() string {
	return HotelWidget{}.Type()
}

type Error string

func (e Error) Error() string {
	return "hotels error: " + string(e)
}

func (class Class) Extend() (common.Widget, error) {
	hotel, err := class.getHotel()
	if err != nil {
		class.Logger.ErrorExtra(class.Name(), "iex hotel convertion failed", logger.Extra{"err": err.Error()})
		return nil, err
	}

	valid := !hotel.Expired(time.Now())
	tomorrow := isTomorrow(hotel)
	subtype, _ := hotel.Subtype()

	switch {

	case subtype == "booking" && valid && !tomorrow:
		return class.makeBookingWidget(hotel)

	case subtype == "booking" && valid && tomorrow:
		return class.makeTomorrowWidget(hotel)

	case subtype == "booking" && !valid:
		return class.makeExpiredWidget(hotel)

	case subtype == "canceled":
		return class.makeExpiredWidget(hotel)

	case subtype == "canceling":
		return class.makeCancelingWidget(hotel)

	case subtype == "reminder" && valid:
		return nil, nil
		//DARIA-58212//return class.makeReminderWidget(hotel)

	case subtype == "reminder" && !valid:
		return nil, nil

	default:
		err = Error("unsupported subtype")
		class.Logger.ErrorExtra(class.Name(), "unsupported subtype", logger.Extra{"subtype": subtype})
	}
	return nil, err
}

func (class Class) mid() string { return class.Fact.Envelope.Mid }

func isTomorrow(hotel Hotel) bool {
	checkin, err := hotel.CheckInDate()
	if err != nil {
		return false
	}
	checkout, err := hotel.CheckOutDate()
	if err != nil {
		checkout = checkin.AddDate(0, 0, 1)
	}
	h24 := 24 * time.Hour
	thisDay := time.Now().Truncate(h24)
	checkinDay := checkin.Truncate(h24)
	checkoutDay := checkout.Truncate(h24)
	theDayBeforeCheckin := checkinDay.AddDate(0, 0, -1)
	return (thisDay.After(theDayBeforeCheckin) || thisDay.Equal(theDayBeforeCheckin)) &&
		(thisDay.Before(checkoutDay) || thisDay.Equal(checkoutDay))
}
