package hotels

import (
	"a.yandex-team.ru/mail/iex/taksa/experiments"
	"a.yandex-team.ru/mail/iex/taksa/types"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
)

type Config struct {
	Types       types.Types             `json:"types"`
	Experiments experiments.Experiments `json:"experiments"`
	Logo        common.LogoCfg          `json:"logo"`
	WeatherLink string                  `json:"weather_link"`
}

func Default() Config {
	return Config{Logo: common.DefaultLogoCfg()}
}

func (config Config) GetUnfilledMandatoryFields() (fields []string) {
	if len(config.Types) == 0 {
		fields = append(fields, "hotels.types")
	}
	if len(config.WeatherLink) == 0 {
		fields = append(fields, "hotels.weather_link")
	}
	fields = append(fields, config.Logo.GetUnfilledMandatoryFields()...)
	return
}

func (config Config) GetTypes() types.Types {
	return config.Types
}

func (config Config) GetExperiments() experiments.Experiments {
	return config.Experiments
}
