package hotels

import (
	"fmt"
	"strings"
	"time"

	"a.yandex-team.ru/mail/iex/taksa/tanker"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
)

func (class Class) getLogo(hotel Hotel, ct common.LogoColorF, icon common.LogoIconF) (c common.Control, err error) {
	service, _ := hotel.Domain()
	logo := common.Logo{Cfg: class.Cfg.Logo, Key: service, DefaultName: class.Fact.Envelope.FromDisplayName}
	return common.MakeLogoControl(common.LogoName(logo), icon(logo), ct(logo), logo.Cfg.Zubchiki), nil
}

func (class Class) getTitleSubject() (common.Control, error) {
	return common.MakeTitleControl(class.Fact.Envelope.Subject), nil
}

func printPersons(cnt int) string {
	if cnt > 3 {
		return fmt.Sprintf("&man;%v", cnt)
	}
	s := make([]string, cnt)
	for i := range s {
		s[i] = "&man;"
	}
	return strings.Join(s, "")
}

func (class Class) getTitleNice(hotel Hotel) (common.Control, error) {
	hotelName, _ := hotel.Name()
	if hotelName == "" {
		return class.getTitleSubject()
	}
	persons, _ := hotel.Persons()
	title := hotelName + " " + printPersons(persons)
	return common.MakeTitleControlWithHTMLEntities(title), nil
}

func (class Class) getDetails(hotel Hotel) (c common.Control, err error) {
	details := fillDetails(hotel, class.Tanker)
	var label string
	if class.Request.GetMobile() {
		label = details.printDetailsFirstLine()
	} else {
		label = details.printDetailsInOneLine()
	}
	c = common.MakeTextControlWithHTMLEntities(common.Description1, label)
	return
}

func (class Class) getDetailsAux(hotel Hotel) (c common.Control, err error) {
	details := fillDetails(hotel, class.Tanker)
	label := ""
	if class.Request.GetMobile() {
		label = details.printDetailsSecondLine()
	}
	c = common.MakeTextControlWithHTMLEntities(common.Description1Aux, label)
	return
}

func (class Class) getFirstline() (common.Control, error) {
	return common.MakeTextControl(common.Description1, class.Fact.Envelope.Firstline), nil
}

func (class Class) getPrice(hotel Hotel) (c common.Control, err error) {
	return common.GetText(common.Description2, hotel.Price)
}

func (class Class) getFreeCancelDate(hotel Hotel) (c common.Control, err error) {
	var date time.Time
	date, _ = hotel.FreeCancelDate()
	var dateStr string
	var ok bool
	if class.Request.GetMobile() {
		dateStr, ok = printShortTime(date, class.Tanker)
	} else {
		dateStr, ok = printTime(date, class.Tanker)
	}
	if !ok {
		err = Error("no cancellation info")
		class.Logger.Error(class.Name(), "no cancellation info")
		return
	}
	var stringLocalized string
	if class.Request.GetMobile() {
		stringLocalized, err = class.Tanker.GetString(tanker.FreeCancelDateShort)
	} else {
		stringLocalized, err = class.Tanker.GetString(tanker.FreeCancelDate)
	}
	c = common.MakeTextControl(common.Description3, fmt.Sprintf("%v %v", stringLocalized, dateStr))
	return
}

func (class Class) getChangeLink(hotel Hotel) (c common.Control, err error) {
	return common.GetLink(common.Action1, hotel.ChangeBookingURL, tanker.ChangeBooking, class.Tanker)
}

func (class Class) getPrint(hotel Hotel) (c common.Control, err error) {
	return common.GetPrint(common.Action2, hotel.PrintParts(), class.Tanker)
}

func (class Class) getCheckWeather(hotel Hotel) (c common.Control, err error) {
	text, _ := class.Tanker.GetString(tanker.CheckWeather)
	city, err := hotel.CityGeoID()
	if err != nil {
		class.Logger.Error(class.Name(), err.Error())
		return
	}
	tld := class.Request.GetTld()
	c = common.MakeLinkControl(common.Action3, text, fmt.Sprintf("%v.%v/%v", class.Cfg.WeatherLink, tld, city))
	return
}
