package hotels

import (
	"a.yandex-team.ru/mail/iex/taksa/tanker"
	"fmt"
	"strings"
	"time"
)

const (
	space string = " "
)

type Details struct {
	City    string
	Country string
	Since   time.Time
	Till    time.Time
	Nights  int
	Tanker  tanker.Interface
}

func fillDetails(hotel Hotel, tnkr tanker.Interface) (details Details) {
	details.Tanker = tnkr
	details.City, _ = hotel.City()
	details.Country, _ = hotel.Country()
	details.Since, _ = hotel.CheckInDate()
	details.Till, _ = hotel.CheckOutDate()
	details.Nights, _ = hotel.Nights()
	return
}

func printTime(t time.Time, tanker tanker.Interface) (res string, ok bool) {
	nilTime := time.Time{}
	if t != nilTime {
		var err error
		res, err = tanker.GetDate(t)
		ok = err == nil
	}
	return
}

func printShortTime(t time.Time, tanker tanker.Interface) (res string, ok bool) {
	nilTime := time.Time{}
	if t != nilTime {
		var err error
		res, err = tanker.GetDateShort(t)
		ok = err == nil
	}
	return
}

func (details Details) printDetailsInOneLine() string {
	city, haveCity := details.City, details.City != ""
	since, haveSince := printTime(details.Since, details.Tanker)
	till, haveTill := printTime(details.Till, details.Tanker)
	haveTimeBounds := haveSince && haveTill
	haveNights := details.Nights > 0
	res := []string{}
	if haveCity {
		res = append(res, city)
		if haveTimeBounds {
			res = append(res, ",")
		}
		if haveTimeBounds || haveNights {
			res = append(res, space)
		}
	}
	if haveTimeBounds {
		res = append(res, fmt.Sprintf("%v &ndash; %v", since, till))
		if haveNights {
			res = append(res, space)
		}
	}
	if details.Nights > 0 {
		nightsL7d, err := details.Tanker.GetNights(details.Nights)
		if err == nil {
			res = append(res, fmt.Sprintf("(%v)", nightsL7d))
		}
	}
	return strings.Join(res, "")
}

func (details Details) printDetailsFirstLine() (res string) {
	if details.City != "" {
		res += details.City
		if details.Country != "" {
			res += "," + space + details.Country
		}
	}
	return
}

func (details Details) printDetailsSecondLine() (res string) {
	since, haveSince := printShortTime(details.Since, details.Tanker)
	till, haveTill := printShortTime(details.Till, details.Tanker)
	if haveSince && haveTill {
		res = fmt.Sprintf("%v &ndash; %v", since, till)
	}
	return
}
