package hotels

import (
	"a.yandex-team.ru/mail/iex/taksa/tutil"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
	"time"
)

type Hotel struct {
	common.IexDict
}

func (class Class) getHotel() (res Hotel, err error) {
	for _, f := range class.Fact.IEX {
		dict, ok := f.(map[string]interface{})
		res = Hotel{dict}
		if ok && res.GetSomething("taksa_widget_type_1234543456546") == "hotels" {
			return
		}
	}
	err = Error("no hotels in iex")
	return
}

func (hotel Hotel) PrintParts() []string {
	return common.PrintParts(hotel.GetSomething("print_parts"))
}

func (hotel Hotel) getDate(name string) (time.Time, error) {
	return tutil.GetTimeFromSomething(hotel.GetSomething(name))
}

func (hotel Hotel) getRfcDate(name string) (time.Time, error) {
	return tutil.GetTimeFromRfcString(hotel.GetSomething(name))
}

func (hotel Hotel) getInt(name string) (int, error) {
	return tutil.GetIntFromSomething(hotel.GetSomething(name))
}

func (hotel Hotel) City() (string, error) {
	return hotel.GetString("city")
}

func (hotel Hotel) Country() (string, error) {
	return hotel.GetString("country")
}

func (hotel Hotel) CityGeoID() (int, error) {
	return hotel.getInt("city_geoid")
}

func (hotel Hotel) CheckInDate() (time.Time, error) {
	return hotel.getRfcDate("checkin_date_rfc")
}

func (hotel Hotel) CheckOutDate() (time.Time, error) {
	return hotel.getRfcDate("checkout_date_rfc")
}

func (hotel Hotel) Nights() (int, error) {
	return hotel.getInt("number_of_nights")
}

func (hotel Hotel) Persons() (int, error) {
	return hotel.getInt("people")
}

func (hotel Hotel) Price() (string, error) {
	return hotel.GetNonEmptyString("price")
}

func (hotel Hotel) FreeCancelDate() (time.Time, error) {
	return hotel.getDate("cancellation_info")
}

func (hotel Hotel) ChangeBookingURL() (string, error) {
	return hotel.GetNonEmptyString("modifyReservationUrl")
}

func (hotel Hotel) Subtype() (string, error) {
	return hotel.GetString("widget_subtype")
}

func (hotel Hotel) Domain() (string, error) {
	return hotel.GetString("domain")
}

func (hotel Hotel) Name() (string, error) {
	return hotel.GetString("hotel")
}

func (hotel Hotel) ExpireDate() *time.Time {
	if retval, err := hotel.CheckOutDate(); err == nil {
		return &retval
	}
	return nil
}

func (hotel Hotel) Expired(now time.Time) bool {
	return hotel.ExpireDate() != nil && hotel.ExpireDate().Unix() <= now.Unix()
}
