package hotels

import "a.yandex-team.ru/mail/iex/taksa/widgets/common"

type HotelWidget struct{}

func (HotelWidget) Type() string { return "hotels" }

type ValidHotelWidget struct {
	common.WidgetBase
	common.ValidTrue
	common.DoubleRowSize
	HotelWidget
}

type ExpiredHotelWidget struct {
	common.WidgetBase
	common.ValidFalse
	common.SingleRowSize
	HotelWidget
}

type BookingWidget struct {
	ValidHotelWidget
	common.BookingSubType
}

type TomorrowWidget struct {
	ValidHotelWidget
	common.TomorrowSubType
}

type ExpiredWidget struct {
	ExpiredHotelWidget
	common.BookingSubType
}

type CancelingWidget struct {
	common.WidgetBase
	common.ValidTrue
	common.SingleRowSize
	HotelWidget
	common.CancelingSubType
}

type ReminderWidget struct {
	ValidHotelWidget
	common.ReminderSubType
}

func (class Class) makeBookingWidget(hotel Hotel) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) {
			return class.getLogo(hotel, common.LogoColorCfg, common.LogoIconRegular)
		},
		func() (common.Control, error) { return class.getTitleNice(hotel) })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getDetails(hotel) },
		func() (common.Control, error) { return class.getDetailsAux(hotel) },
		func() (common.Control, error) { return class.getPrice(hotel) },
		func() (common.Control, error) { return class.getFreeCancelDate(hotel) },
		func() (common.Control, error) { return class.getChangeLink(hotel) },
		func() (common.Control, error) { return class.getPrint(hotel) })...)
	return common.InitWidget(&BookingWidget{}, class.mid(), &accum, hotel.ExpireDate())
}

func (class Class) makeReminderWidget(hotel Hotel) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) {
			return class.getLogo(hotel, common.LogoColorYa, common.LogoIconBright)
		},
		func() (common.Control, error) { return class.getTitleSubject() })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getDetails(hotel) },
		func() (common.Control, error) { return class.getDetailsAux(hotel) },
		func() (common.Control, error) { return class.getCheckWeather(hotel) },
		func() (common.Control, error) { return class.getPrint(hotel) })...)
	return common.InitWidget(&ReminderWidget{}, class.mid(), &accum, hotel.ExpireDate())
}

func (class Class) makeTomorrowWidget(hotel Hotel) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) {
			return class.getLogo(hotel, common.LogoColorCfg, common.LogoIconRegular)
		},
		func() (common.Control, error) { return class.getTitleNice(hotel) })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getDetails(hotel) },
		func() (common.Control, error) { return class.getDetailsAux(hotel) },
		func() (common.Control, error) { return class.getCheckWeather(hotel) },
		func() (common.Control, error) { return class.getPrint(hotel) })...)
	return common.InitWidget(&TomorrowWidget{}, class.mid(), &accum, hotel.ExpireDate())
}

func (class Class) makeExpiredWidget(hotel Hotel) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) {
			return class.getLogo(hotel, common.LogoColorYa, common.LogoIconRegular)
		},
		func() (common.Control, error) { return class.getTitleSubject() })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getFirstline() })...)
	return common.InitWidget(&ExpiredWidget{}, class.mid(), &accum, hotel.ExpireDate())
}

func (class Class) makeCancelingWidget(hotel Hotel) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) {
			return class.getLogo(hotel, common.LogoColorYa, common.LogoIconRegular)
		},
		func() (common.Control, error) { return class.getTitleSubject() })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getFirstline() })...)
	return common.InitWidget(&CancelingWidget{}, class.mid(), &accum, hotel.ExpireDate())
}
