package onelink

import (
	"a.yandex-team.ru/mail/iex/taksa/iex"
	"a.yandex-team.ru/mail/iex/taksa/logger"
	"a.yandex-team.ru/mail/iex/taksa/tanker"
	"a.yandex-team.ru/mail/iex/taksa/tutil"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
)

type Class struct {
	Cfg    Config
	Fact   iex.Fact
	Logger logger.Interface
	Tanker tanker.Interface
}

func (class Class) Name() string {
	return OneLinkWidget{}.Type()
}

type Error string

func (e Error) Error() string {
	return "onelink error: " + string(e)
}

type OneLinkType struct{}

func (OneLinkType) Type() string { return "onelink" }

type OneLinkWidget struct {
	common.WidgetBase
	common.ValidTrue
	common.SingleRowSize
	OneLinkType
	OneLinkSubType
}

type OneLinkSubType struct{}

func (OneLinkSubType) SubType() string { return "onelink" }

func (class Class) Extend() (w common.Widget, err error) {
	linkInfo, err := class.getLinkInfo()
	if err != nil {
		class.Logger.ErrorExtra(class.Name(), "iex onelink convertion failed", logger.Extra{"err": err.Error()})
		return nil, err
	}

	subtype, _ := linkInfo.getSubtype()
	domain, _ := tutil.DomainFromEmail(class.Fact.Envelope.FromAddress)
	if isMicroSubtype(subtype) && !tutil.ContainsString(domain, class.Cfg.MicroTrustedDomains) {
		class.Logger.ErrorExtra(class.Name(), "not trusted domain for micro", logger.Extra{"domain": domain})
		return nil, nil
	}

	label, err := linkInfo.getText(class.Tanker)
	if err != nil || label == "" {
		return nil, err
	}
	value, err := linkInfo.getURL()
	if err != nil {
		class.Logger.Error(class.Name(), "no url in iex")
		return nil, err
	}
	link := common.MakeLinkControl(common.Action1, label, value)
	w = &OneLinkWidget{}
	w.Init(class.Fact.Envelope.Mid, []common.Control{link}, nil, "", "")
	return
}
