package onelink

import (
	"a.yandex-team.ru/mail/iex/taksa/tanker"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
)

type LinkInfo struct {
	common.IexDict
}

func (class Class) getLinkInfo() (res LinkInfo, err error) {
	for _, f := range class.Fact.IEX {
		dict, ok := f.(map[string]interface{})
		res = LinkInfo{dict}
		if ok && res.GetSomething("taksa_widget_type_1234543456546") == "action" {
			return
		}
	}
	err = Error("no onelink in iex")
	return
}

func (linkInfo LinkInfo) getURL() (string, error) {
	return linkInfo.GetNonEmptyString("url")
}

func (linkInfo LinkInfo) getSubtype() (string, error) {
	return linkInfo.GetString("widget_subtype")
}

func isMicroSubtype(subtype string) bool {
	return subtype == "view_action" ||
		subtype == "confirm_action" ||
		subtype == "save_action"
}

func (linkInfo LinkInfo) getText(tnkr tanker.Interface) (string, error) {
	subtype, _ := linkInfo.getSubtype()
	switch {
	case isMicroSubtype(subtype):
		return linkInfo.GetString("name")
	case subtype == "confirm_email":
		return tnkr.GetString(tanker.ConfirmEmail)
	case subtype == "restore_password":
		return tnkr.GetString(tanker.RestorePassword)
	case subtype == "unsubscribe":
		//return tnkr.GetString(tanker.Unsubscribe)
		//Lida asked to temporarily disable unsubscribe widgets
		return "", nil
	default:
		return "", Error("invalid subtype " + subtype)
	}
}
