package pkpass

import (
	"a.yandex-team.ru/mail/iex/taksa/iex"
	"a.yandex-team.ru/mail/iex/taksa/logger"
	"a.yandex-team.ru/mail/iex/taksa/tanker"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
	"time"
)

type Class struct {
	Cfg    Config
	Fact   iex.Fact
	Logger logger.Interface
	Tanker tanker.Interface
}

func (class Class) Name() string {
	return PkpassWidget{}.Type()
}

type Error string

func (e Error) Error() string {
	return "pkpass error: " + string(e)
}

func (class Class) Extend() (common.Widget, error) {
	pass, err := class.getPass()
	if err != nil {
		class.Logger.ErrorExtra(class.Name(), "iex pkpass convertion failed", logger.Extra{"err": err.Error()})
		return nil, err
	}

	valid := !pass.Expired(time.Now())
	subtype, _ := pass.Subtype()

	switch {
	case !valid:
		return nil, nil

	case subtype == "cinema" && valid:
		return class.makeCinemaWidget(pass)

	default:
		err = Error("unsupported subtype")
		class.Logger.ErrorExtra(class.Name(), "unsupported subtype", logger.Extra{"subtype": subtype})
	}
	return nil, err
}

func (class Class) mid() string { return class.Fact.Envelope.Mid }
