package pkpass

import (
	"a.yandex-team.ru/mail/iex/taksa/tanker"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
	"fmt"
	"time"
)

func (class Class) getLogo(pass Pass, ct common.LogoColorF, icon common.LogoIconF) (c common.Control, err error) {
	service, _ := pass.Domain()
	logo := common.Logo{Cfg: class.Cfg.Logo, Key: service, DefaultName: class.Fact.Envelope.FromDisplayName}
	return common.MakeLogoControl(common.LogoName(logo), icon(logo), ct(logo), logo.Cfg.Zubchiki), nil
}

func (class Class) getMovie(pass Pass) (c common.Control, err error) {
	movie, err := pass.Title()
	if err != nil {
		class.Logger.Error(class.Name(), err.Error())
		return
	}
	c = common.MakeTitleControl(movie)
	return
}

func printTime(t time.Time, tanker tanker.Interface) (res string, ok bool) {
	nilTime := time.Time{}
	if t != nilTime {
		time := t.Format("15:04")
		date, err := tanker.GetDate(t)
		ok = err == nil
		res = fmt.Sprintf("%v %v", date, time)
	}
	return
}

type Details struct {
	Location string
	Date     time.Time
}

func (details Details) printDetails(t tanker.Interface) string {
	date, haveDate := printTime(details.Date, t)
	if haveDate {
		if details.Location != "" {
			return fmt.Sprintf("%v, %v", date, details.Location)
		} else {
			return date
		}
	}
	return details.Location
}

func (class Class) getDetails(pass Pass) (c common.Control, err error) {
	var details Details
	details.Location, _ = pass.Location()
	details.Date, _ = pass.Date()
	c = common.MakeTextControl(common.Description1, details.printDetails(class.Tanker))
	return
}

func (class Class) getCount(pass Pass) (c common.Control, err error) {
	var count int
	count, err = pass.Count()
	if err != nil {
		class.Logger.Error(class.Name(), err.Error())
		return
	}
	tickets, _ := class.Tanker.GetTickets(count)
	c = common.MakeTextControl(common.Description2, tickets)
	return
}

func (class Class) getSeats(pass Pass) (c common.Control, err error) {
	iexSeats, err := pass.Seats()
	if err != nil {
		class.Logger.Error(class.Name(), err.Error())
		return
	}
	rows := makeRows(iexSeats)
	c = common.MakeTextControl(common.Description3, printRows(rows, class.Tanker))
	return
}

func (class Class) getPrint(pass Pass) (c common.Control, err error) {
	return common.GetPrint(common.Action1, pass.PrintParts(), class.Tanker)
}
