package pkpass

import (
	"a.yandex-team.ru/mail/iex/taksa/tutil"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
	"time"
)

type Pass struct {
	common.IexDict
}

func (class Class) getPass() (res Pass, err error) {
	for _, f := range class.Fact.IEX {
		dict, ok := f.(map[string]interface{})
		res = Pass{dict}
		if ok && res.GetSomething("taksa_widget_type_1234543456546") == "event-ticket" {
			return
		}
	}
	err = Error("no pkpass in iex")
	return
}

func (pass Pass) PrintParts() []string {
	return common.PrintParts(pass.GetSomething("print_parts"))
}

func (pass Pass) getDate(name string) (time.Time, error) {
	return tutil.GetTimeFromSomething(pass.GetSomething(name))
}

func (pass Pass) getInt(name string) (int, error) {
	return tutil.GetIntFromSomething(pass.GetSomething(name))
}

func (pass Pass) Domain() (string, error) {
	return pass.GetString("domain")
}

func (pass Pass) Title() (string, error) {
	return pass.GetNonEmptyString("title")
}

func (pass Pass) Subtype() (string, error) {
	return pass.GetString("widget_subtype")
}

func (pass Pass) Location() (string, error) {
	var location string
	place, ok := pass.GetSomething("location").(map[string]interface{})
	if !ok {
		return "", Error("no \"location\" with type map[string]interface{} found")
	}
	location, ok = place["name"].(string)
	if !ok {
		return "", Error("no \"name\" in \"location\" with type string found")
	}
	return location, nil
}

func (pass Pass) Date() (time.Time, error) {
	return pass.getDate("start_date_ts")
}

func (pass Pass) Count() (int, error) {
	return pass.getInt("num_seats")
}

func (pass Pass) Seats() ([]interface{}, error) {
	return common.GetInterfaceSlice(pass.GetSomething("seats"))
}

func (pass Pass) ExpireDate() *time.Time {
	if retval, err := pass.Date(); err == nil {
		return &retval
	}
	return nil
}

func (pass Pass) Expired(now time.Time) bool {
	return pass.ExpireDate() != nil && pass.ExpireDate().Unix() <= now.Unix()
}
