package pkpass

import (
	"a.yandex-team.ru/mail/iex/taksa/tanker"
	"a.yandex-team.ru/mail/iex/taksa/tutil"
	"fmt"
	"sort"
	"strings"
)

type Seats []int

type Row struct {
	Number int
	Seats  Seats
}

type Rows []Row

func (rows Rows) Len() int           { return len(rows) }
func (rows Rows) Swap(i, j int)      { rows[i], rows[j] = rows[j], rows[i] }
func (rows Rows) Less(i, j int) bool { return rows[i].Number < rows[j].Number }

func makeRows(iex []interface{}) (rows Rows) {
	mapp := map[int][]int{}
	for _, something := range iex {
		if v, ok := something.(map[string]interface{}); ok {
			row, hasRow := v["row"].(float64)
			seat, hasSeat := v["seat"].(float64)
			if hasRow && hasSeat {
				mapp[int(row)] = append(mapp[int(row)], int(seat))
			}
		}
	}
	for row, seats := range mapp {
		rows = append(rows, Row{Number: row, Seats: seats})
	}
	sort.Sort(rows)
	return
}

func printRows(rows Rows, tnkr tanker.Interface) string {
	res := []string{}
	for _, row := range rows {
		seatWord, _ := tnkr.GetString(tanker.Seat)
		andWord, _ := tnkr.GetString(tanker.And)
		var seatsString string
		if len(row.Seats) == 1 {
			seatsString = fmt.Sprintf("%v %v", seatWord, row.Seats[0])
		} else {
			seatsExceptLast := row.Seats[0 : len(row.Seats)-1]
			commaSeparatedSeats := tutil.PrintIntSlice(seatsExceptLast)
			lastSeat := row.Seats[len(row.Seats)-1]
			seatsString = fmt.Sprintf("%v %v %v %v", seatWord, commaSeparatedSeats, andWord, lastSeat)
		}
		rowWord, _ := tnkr.GetString(tanker.Row)
		rowString := fmt.Sprintf("%v %v, %v", rowWord, row.Number, seatsString)
		res = append(res, rowString)
	}
	return strings.Join(res, "; ")
}
