package pkpass

import "a.yandex-team.ru/mail/iex/taksa/widgets/common"

type PkpassWidget struct{}

func (PkpassWidget) Type() string { return "pkpass" }

type ValidPkpassWidget struct {
	common.WidgetBase
	common.ValidTrue
	common.DoubleRowSize
	PkpassWidget
}

type ExpiredPkpassWidget struct {
	common.WidgetBase
	common.ValidFalse
	common.SingleRowSize
	PkpassWidget
}

type CinemaWidget struct {
	ValidPkpassWidget
	common.CinemaSubType
}

func (class Class) makeCinemaWidget(pass Pass) (common.Widget, error) {
	var accum common.Accumulator
	accum.Add(
		func() (common.Control, error) {
			return class.getLogo(pass, common.LogoColorCfg, common.LogoIconRegular)
		},
		func() (common.Control, error) { return class.getMovie(pass) })
	accum.Add(common.SuppressError(
		func() (common.Control, error) { return class.getDetails(pass) },
		func() (common.Control, error) { return class.getCount(pass) },
		func() (common.Control, error) { return class.getSeats(pass) },
		func() (common.Control, error) { return class.getPrint(pass) })...)
	return common.InitWidget(&CinemaWidget{}, class.mid(), &accum, pass.ExpireDate())
}
