package snippet

import (
	"a.yandex-team.ru/mail/iex/taksa/iex"
	"a.yandex-team.ru/mail/iex/taksa/logger"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
)

type Class struct {
	Cfg    Config
	Fact   iex.Fact
	Logger logger.Interface
}

func (class Class) Name() string {
	return SnippetWidget{}.Type()
}

type Error string

func (e Error) Error() string {
	return "snippet error: " + string(e)
}

type SnippetType struct{}

func (SnippetType) Type() string { return "snippet" }

type SnippetWidget struct {
	common.WidgetBase
	common.ValidTrue
	common.SingleRowSize
	SnippetType
	SnippetSubType
}

type SnippetSubType struct{}

func (SnippetSubType) SubType() string { return "snippet" }

func (class Class) Extend() (w common.Widget, err error) {
	snippetInfo, err := class.getSnippetInfo()
	if err != nil {
		class.Logger.ErrorExtra(class.Name(), "fact convertion failed", logger.Extra{"err": err.Error()})
		return nil, err
	}

	text, err := snippetInfo.getText()
	if err != nil {
		class.Logger.ErrorExtra(class.Name(), "get text error", logger.Extra{"err": err.Error()})
		return nil, err
	}
	ctrl := common.MakeTextControl(common.Special1, text)
	w = &SnippetWidget{}
	w.Init(class.Fact.Envelope.Mid, []common.Control{ctrl}, nil, "", "")
	return
}
