package snippet

import "a.yandex-team.ru/mail/iex/taksa/widgets/common"

type SnippetInfo struct {
	common.IexDict
}

func (class Class) getSnippetInfo() (res SnippetInfo, err error) {
	for _, f := range class.Fact.IEX {
		dict, ok := f.(map[string]interface{})
		res = SnippetInfo{dict}
		if ok && res.GetSomething("taksa_widget_type_1234543456546") == "snippet-text" {
			return
		}
	}
	err = Error("no snippet in iex")
	return
}

func (snippetInfo SnippetInfo) getText() (string, error) {
	return snippetInfo.GetNonEmptyString("text")
}
