package spam

import (
	"a.yandex-team.ru/mail/iex/taksa/iex"
	"a.yandex-team.ru/mail/iex/taksa/logger"
	"a.yandex-team.ru/mail/iex/taksa/tanker"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
)

type Class struct {
	Cfg    Config
	Fact   iex.Fact
	Logger logger.Interface
	Tanker tanker.Interface
}

type Error string

func (e Error) Error() string {
	return "spam error: " + string(e)
}

func (Class) Name() string { return SpamWidget{}.Type() }

func (class Class) mid() string { return class.Fact.Envelope.Mid }

type SpamType struct{}

func (SpamType) Type() string { return "spam" }

type SpamSubType struct{}

func (SpamSubType) SubType() string { return "spam" }

type SpamWidget struct {
	common.WidgetBase
	common.ValidTrue
	common.SingleRowSize
	SpamType
	SpamSubType
}

func (class Class) Extend() (w common.Widget, err error) {
	from := class.Fact.Envelope.FromDisplayName
	color := class.Cfg.Logo.LogoColorDefault
	zubchiki := class.Cfg.Logo.Zubchiki
	subject := class.Fact.Envelope.Subject
	label, _ := class.Tanker.GetString(tanker.Spam)
	logo := common.MakeLogoControl(from, "", color, zubchiki)
	title := "<b>" + label + "</b><span style=\"opacity:0.6;font-weight:normal;\">" + subject + "</span>"
	titleControl := common.MakeTitleControlWithHTMLEntities(title)
	w = &SpamWidget{}
	w.Init(class.Fact.Envelope.Mid, []common.Control{logo, titleControl}, nil, "", "")
	return
}
