package spam

import (
	"a.yandex-team.ru/mail/iex/taksa/experiments"
	"a.yandex-team.ru/mail/iex/taksa/types"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
)

type Days int

type Config struct {
	Types       types.Types             `json:"types"`
	Experiments experiments.Experiments `json:"experiments"`
	Logo        common.LogoCfg          `json:"logo"`
}

func Default() Config {
	return Config{Logo: common.DefaultLogoCfg()}
}

func (config Config) GetUnfilledMandatoryFields() (fields []string) {
	if len(config.Types) == 0 {
		fields = append(fields, "spam.types")
	}
	return
}

func (config Config) GetTypes() types.Types {
	return config.Types
}

func (config Config) GetExperiments() experiments.Experiments {
	return config.Experiments
}
