package tracker

import (
	"a.yandex-team.ru/mail/iex/taksa/iex"
	"a.yandex-team.ru/mail/iex/taksa/logger"
	"a.yandex-team.ru/mail/iex/taksa/widgets/common"
)

type Class struct {
	Cfg    Config
	Fact   iex.Fact
	Logger logger.Interface
}

func (class Class) Name() string {
	return TrackerWidget{}.Type()
}

type Error string

func (e Error) Error() string {
	return "tracker error: " + string(e)
}

type TrackerType struct{}

func (TrackerType) Type() string { return "tracker" }

type TrackerWidget struct {
	common.WidgetBase
	common.ValidTrue
	common.SingleRowSize
	TrackerType
	TrackerSubType
}

type TrackerSubType struct{}

func (TrackerSubType) SubType() string { return "tracker" }

func (class Class) Extend() (w common.Widget, err error) {
	trackerInfo, err := class.getTrackerInfo()
	if err != nil {
		class.Logger.ErrorExtra(class.Name(), "iex tracker convertion failed", logger.Extra{"err": err.Error()})
		return nil, err
	}

	value, err := trackerInfo.getURL()
	if err != nil {
		class.Logger.Error(class.Name(), "no url in iex")
		return nil, err
	}
	imglink := common.MakeImgLinkControl(common.Action1, class.Cfg.Img, value)
	w = &TrackerWidget{}
	w.Init(class.Fact.Envelope.Mid, []common.Control{imglink}, nil, "", "")
	return
}
