package tracker

import (
	"a.yandex-team.ru/mail/iex/taksa/experiments"
	"a.yandex-team.ru/mail/iex/taksa/types"
)

type Config struct {
	Types       types.Types             `json:"types"`
	Experiments experiments.Experiments `json:"experiments"`
	Img         string                  `json:"img"`
}

func Default() Config {
	return Config{}
}

func (config Config) GetUnfilledMandatoryFields() (fields []string) {
	if len(config.Types) == 0 {
		fields = append(fields, "tracker.types")
	}
	if config.Img == "" {
		fields = append(fields, "tracker.img")
	}
	return
}

func (config Config) GetTypes() types.Types {
	return config.Types
}

func (config Config) GetExperiments() experiments.Experiments {
	return config.Experiments
}
