package tracker

import "a.yandex-team.ru/mail/iex/taksa/widgets/common"

type TrackerInfo struct {
	common.IexDict
}

func (class Class) getTrackerInfo() (res TrackerInfo, err error) {
	for _, f := range class.Fact.IEX {
		dict, ok := f.(map[string]interface{})
		res = TrackerInfo{dict}
		if ok && res.GetSomething("taksa_widget_type_1234543456546") == "action" {
			return
		}
	}
	return TrackerInfo{}, Error("no tracker in iex")
}

func (info TrackerInfo) getURL() (string, error) {
	return info.GetNonEmptyString("url")
}
